/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionList;

public class TagFieldEditor
extends JTextField {
    private static Logger logger = Logger.getLogger(TagFieldEditor.class.getName());
    protected AutoCompletionList autoCompletionList = null;

    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    public TagFieldEditor() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TagFieldEditor.this.selectAll();
                TagFieldEditor.this.applyFilter(TagFieldEditor.this.getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (TagFieldEditor.this.getText().equals("")) {
                    TagFieldEditor.this.applyFilter("");
                }
            }
        });
    }

    protected void applyFilter(String string) {
        if (this.autoCompletionList != null) {
            this.autoCompletionList.applyFilter(string);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (TagFieldEditor.this.autoCompletionList == null) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (n < this.getLength()) {
                super.insertString(n, string, attributeSet);
                return;
            }
            String string2 = this.getText(0, this.getLength());
            String string3 = string2.substring(0, n);
            TagFieldEditor.this.autoCompletionList.applyFilter(string3 + string);
            if (TagFieldEditor.this.autoCompletionList.getFilteredSize() > 0) {
                String string4 = TagFieldEditor.this.autoCompletionList.getFilteredItem(0).getValue();
                this.remove(0, this.getLength());
                super.insertString(0, string4, attributeSet);
                TagFieldEditor.this.setCaretPosition(this.getLength());
                TagFieldEditor.this.moveCaretPosition(n + string.length());
            } else {
                String string5 = string3 + string;
                this.remove(0, this.getLength());
                super.insertString(0, string5, attributeSet);
                TagFieldEditor.this.setCaretPosition(this.getLength());
            }
        }
    }
}

