/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.ac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionList
extends AbstractTableModel {
    private ArrayList<AutoCompletionListItem> list = new ArrayList();
    private ArrayList<AutoCompletionListItem> filtered = new ArrayList();
    private String filter = null;

    public void applyFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument 'filter' must not be null");
        }
        this.filter = string;
        this.filter();
    }

    public void clearFilter() {
        this.filter = null;
        this.filter();
    }

    public String getFilter() {
        return this.filter;
    }

    public void add(AutoCompletionListItem autoCompletionListItem) {
        if (autoCompletionListItem == null) {
            return;
        }
        this.appendOrUpdatePriority(autoCompletionListItem);
        this.sort();
        this.filter();
    }

    public void add(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            throw new IllegalArgumentException("argument 'other' must not be null");
        }
        for (AutoCompletionListItem autoCompletionListItem : autoCompletionList.list) {
            this.appendOrUpdatePriority(autoCompletionListItem);
        }
        this.sort();
        this.filter();
    }

    public void add(List<AutoCompletionListItem> list) {
        if (list == null) {
            throw new IllegalArgumentException("argument 'other' must not be null");
        }
        for (AutoCompletionListItem autoCompletionListItem : list) {
            this.appendOrUpdatePriority(autoCompletionListItem);
        }
        this.sort();
        this.filter();
    }

    protected void appendOrUpdatePriority(AutoCompletionListItem autoCompletionListItem) {
        AutoCompletionListItem autoCompletionListItem2 = this.lookup(autoCompletionListItem.getValue());
        if (autoCompletionListItem2 == null) {
            this.list.add(autoCompletionListItem);
        } else if (autoCompletionListItem.getPriority().compareTo(autoCompletionListItem2.getPriority()) < 0) {
            autoCompletionListItem2.setPriority(autoCompletionListItem.getPriority());
        }
    }

    public boolean contains(AutoCompletionListItem autoCompletionListItem) {
        if (autoCompletionListItem == null) {
            return false;
        }
        return this.list.contains(autoCompletionListItem);
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        for (AutoCompletionListItem autoCompletionListItem : this.list) {
            if (!autoCompletionListItem.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public AutoCompletionListItem lookup(String string) {
        if (string == null) {
            return null;
        }
        for (AutoCompletionListItem autoCompletionListItem : this.list) {
            if (!autoCompletionListItem.getValue().equals(string)) continue;
            return autoCompletionListItem;
        }
        return null;
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            AutoCompletionListItem autoCompletionListItem = this.list.get(i);
            if (!autoCompletionListItem.getValue().equals(string)) continue;
            this.list.remove(i);
            return;
        }
    }

    protected void sort() {
        Collections.sort(this.list);
    }

    protected void filter() {
        this.filtered.clear();
        if (this.filter == null) {
            this.filtered.ensureCapacity(this.list.size());
            for (AutoCompletionListItem autoCompletionListItem : this.list) {
                this.filtered.add(autoCompletionListItem);
            }
            return;
        }
        for (AutoCompletionListItem autoCompletionListItem : this.list) {
            if (!autoCompletionListItem.getValue().startsWith(this.filter)) continue;
            this.filtered.add(autoCompletionListItem);
        }
        this.fireTableDataChanged();
    }

    public int getFilteredSize() {
        return this.filtered.size();
    }

    public AutoCompletionListItem getFilteredItem(int n) {
        if (n < 0 || n >= this.getFilteredSize()) {
            throw new IndexOutOfBoundsException("idx out of bounds. idx=" + n);
        }
        return this.filtered.get(n);
    }

    public void clear() {
        this.list.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.getFilteredSize();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.list == null ? null : this.getFilteredItem(n);
    }
}

