/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.tools.I18n;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JLabel lblInfo;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.lblInfo = new JLabel();
        this.lblInfo.setHorizontalAlignment(2);
        this.add((Component)this.lblInfo, "Center");
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        String string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong> by <strong>{2}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()), historyOsmPrimitive.getUser());
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "pointInTimeType"));
        }
        if (historyBrowserModel == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "model"));
        }
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    public void update(Observable observable, Object object) {
        this.lblInfo.setText(this.getInfoText());
    }
}

