/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.historycombobox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.gui.historycombobox.HistoryChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxHistory
extends DefaultComboBoxModel
implements Iterable<String> {
    private int maxSize = 10;
    private List<HistoryChangedListener> listeners = new ArrayList<HistoryChangedListener>();

    public ComboBoxHistory(int n) {
        this.maxSize = n;
    }

    @Override
    public void addElement(Object object) {
        String string = (String)object;
        for (int i = 0; i < this.getSize(); ++i) {
            String string2 = (String)this.getElementAt(i);
            if (!string2.equals(string)) continue;
            this.removeElementAt(i);
        }
        this.insertElementAt(object, 0);
        if (this.getSize() > this.maxSize) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.setSelectedItem(object);
        this.fireHistoryChanged();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int position = -1;

            @Override
            public void remove() {
                ComboBoxHistory.this.removeElementAt(this.position);
            }

            @Override
            public boolean hasNext() {
                return this.position < ComboBoxHistory.this.getSize() - 1 && ComboBoxHistory.this.getSize() > 0;
            }

            @Override
            public String next() {
                ++this.position;
                return ComboBoxHistory.this.getElementAt(this.position).toString();
            }
        };
    }

    public void setItems(List<String> list) {
        this.removeAllElements();
        Collections.reverse(list);
        for (String string : list) {
            this.addElement(string);
        }
        Collections.reverse(list);
    }

    public List<String> asList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.maxSize);
        for (String string : this) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.listeners.add(historyChangedListener);
    }

    public void removeHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.listeners.remove(historyChangedListener);
    }

    private void fireHistoryChanged() {
        for (HistoryChangedListener historyChangedListener : this.listeners) {
            historyChangedListener.historyChanged(this.asList());
        }
    }
}

