/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.FilePreferences;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.ProxyPreferences;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceDialog
extends JTabbedPane {
    private static final Collection<PreferenceSettingFactory> settingsFactory = new LinkedList<PreferenceSettingFactory>();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    public final JPanel display = this.createPreferenceTab("display", I18n.tr("Display Settings"), I18n.tr("Various settings that influence the visual representation of the whole program."));
    public final JPanel connection = this.createPreferenceTab("connection", I18n.tr("Connection Settings"), I18n.tr("Connection Settings for the OSM server."));
    public final JPanel map = this.createPreferenceTab("map", I18n.tr("Map Settings"), I18n.tr("Settings for the map projection and data interpretation."));
    public final JPanel audio = this.createPreferenceTab("audio", I18n.tr("Audio Settings"), I18n.tr("Settings for the audio player and audio markers."));
    public final JTabbedPane displaycontent = new JTabbedPane();
    public final JTabbedPane mapcontent = new JTabbedPane();

    public JPanel createPreferenceTab(String string, String string2, String string3) {
        return this.createPreferenceTab(string, string2, string3, false);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(string2), GBC.eol().anchor(10).insets(0, 5, 0, 10));
        JLabel jLabel = new JLabel("<html>" + string3 + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        JComponent jComponent = jPanel;
        if (bl) {
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jComponent = jScrollPane;
        }
        this.addTab(null, ImageProvider.get("preferences", string), jComponent);
        this.setToolTipTextAt(this.getTabCount() - 1, "<html>" + string3 + "</html>");
        return jPanel;
    }

    public void ok() {
        boolean bl = false;
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!preferenceSetting.ok()) continue;
            bl = true;
        }
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You have to restart JOSM for some settings to take effect."));
        }
        Main.parent.repaint();
    }

    public PreferenceDialog() {
        super(2, 1);
        for (PreferenceSettingFactory preferenceSettingFactory : settingsFactory) {
            PreferenceSetting preferenceSetting = preferenceSettingFactory.createPreferenceSetting();
            if (preferenceSetting == null) continue;
            this.settings.add(preferenceSettingFactory.createPreferenceSetting());
        }
        this.display.add((Component)this.displaycontent, GBC.eol().fill(1));
        this.map.add((Component)this.mapcontent, GBC.eol().fill(1));
        Iterator<Object> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            try {
                ((PreferenceSetting)iterator.next()).addGui(this);
            }
            catch (SecurityException securityException) {
                iterator.remove();
            }
            catch (Throwable throwable) {
                BugReportExceptionHandler.handleException(throwable);
            }
        }
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    static {
        settingsFactory.add(new DrawingPreference.Factory());
        settingsFactory.add(new ColorPreference.Factory());
        settingsFactory.add(new LafPreference.Factory());
        settingsFactory.add(new LanguagePreference.Factory());
        settingsFactory.add(new ServerAccessPreference.Factory());
        settingsFactory.add(new FilePreferences.Factory());
        settingsFactory.add(new ProxyPreferences.Factory());
        settingsFactory.add(new ProjectionPreference.Factory());
        settingsFactory.add(new MapPaintPreference.Factory());
        settingsFactory.add(new TaggingPresetPreference.Factory());
        settingsFactory.add(new PluginPreference.Factory());
        settingsFactory.add(Main.toolbar);
        settingsFactory.add(new AudioPreference.Factory());
        settingsFactory.add(new ShortcutPreference.Factory());
        PluginHandler.getPreferenceSetting(settingsFactory);
        settingsFactory.add(new AdvancedPreference.Factory());
    }
}

