/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmServerObjectReader
extends OsmServerReader {
    long id;
    OsmPrimitiveType type;
    boolean full;

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) {
        this.id = l;
        this.type = osmPrimitiveType;
        this.full = bl;
    }

    public DataSet parseOsm() throws OsmTransferException {
        try {
            InputStream inputStream;
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.type.getAPIName());
            stringBuffer.append("/");
            stringBuffer.append(this.id);
            if (this.full && !this.type.equals((Object)OsmPrimitiveType.NODE)) {
                stringBuffer.append("/full");
            }
            if ((inputStream = this.getInputStream(stringBuffer.toString(), Main.pleaseWaitDlg)) == null) {
                return null;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
            OsmReader osmReader = OsmReader.parseDataSetOsm(inputStream, Main.pleaseWaitDlg);
            DataSet dataSet = osmReader.getDs();
            if (osmReader.getParseNotes().length() != 0) {
                JOptionPane.showMessageDialog(Main.parent, osmReader.getParseNotes());
            }
            inputStream.close();
            this.activeConnection = null;
            return dataSet;
        }
        catch (IOException iOException) {
            if (this.cancel) {
                return null;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                return null;
            }
            throw new OsmTransferException(exception);
        }
    }
}

