/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

public abstract class OsmServerReader
extends OsmConnection {
    private OsmApi api = OsmApi.getOsmApi();

    protected InputStream getInputStream(String string, PleaseWaitDialog pleaseWaitDialog) throws OsmTransferException {
        this.api.initialize();
        string = this.api.getBaseUrl() + string;
        return this.getInputStreamRaw(string, pleaseWaitDialog);
    }

    protected InputStream getInputStreamRaw(String string, PleaseWaitDialog pleaseWaitDialog) throws OsmTransferException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new OsmTransferException(malformedURLException);
        }
        try {
            this.activeConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (Exception exception) {
            throw new OsmTransferException(I18n.tr("Failed to open connection to API {0}", uRL.toExternalForm()), exception);
        }
        if (this.cancel) {
            this.activeConnection.disconnect();
            return null;
        }
        if (Main.pref.getBoolean("osm-server.use-compression", true)) {
            this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        this.activeConnection.setConnectTimeout(15000);
        try {
            System.out.println("GET " + uRL);
            this.activeConnection.connect();
        }
        catch (Exception exception) {
            throw new OsmTransferException(I18n.tr("Couldn't connect to the osm server. Please check your internet connection."), exception);
        }
        try {
            if (this.isAuthCancelled() && this.activeConnection.getResponseCode() == 401) {
                throw new OsmApiException(401, null, null);
            }
            if (this.activeConnection.getResponseCode() != 200) {
                String string2 = this.activeConnection.getHeaderField("Error");
                InputStream inputStream = null;
                inputStream = this.activeConnection.getErrorStream();
                StringBuilder stringBuilder = new StringBuilder();
                if (inputStream != null) {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string3);
                        stringBuilder.append("\n");
                    }
                }
                throw new OsmApiException(this.activeConnection.getResponseCode(), string2, stringBuilder.toString());
            }
            String string4 = this.activeConnection.getContentEncoding();
            InputStream inputStream = new ProgressInputStream(this.activeConnection, pleaseWaitDialog);
            if (string4 != null && string4.equalsIgnoreCase("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string4 != null && string4.equalsIgnoreCase("deflate")) {
                inputStream = new InflaterInputStream(inputStream, new Inflater(true));
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof OsmTransferException) {
                throw (OsmTransferException)exception;
            }
            throw new OsmTransferException(exception);
        }
    }

    public abstract DataSet parseOsm() throws OsmTransferException;
}

