/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void uncaughtException(Thread thread, Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    public static void handleException(Throwable throwable) {
        throwable.printStackTrace();
        if (Main.parent != null) {
            if (throwable instanceof OutOfMemoryError) {
                JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.");
                return;
            }
            if (PluginHandler.checkException(throwable).booleanValue()) {
                return;
            }
            Object[] objectArray = new String[]{I18n.tr("Do nothing"), I18n.tr("Report Bug")};
            int n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("An unexpected exception occurred.\n\nThis is always a coding error. If you are running the latest\nversion of JOSM, please consider being kind and file a bug report."), I18n.tr("Unexpected Exception"), 0, 0, null, objectArray, objectArray[0]);
            if (n == 1) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    String string = ShowStatusReportAction.getReportHeader() + stringWriter.getBuffer().toString();
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    jPanel.add((Component)new JLabel("<html>" + I18n.tr("Please report a ticket at {0}", "http://josm.openstreetmap.de/newticket") + "<br>" + I18n.tr("Include your steps to get to the error (as detailed as possible)!") + "<br>" + I18n.tr("Try updating to the newest version of JOSM and all plugins before reporting a bug.") + "<br>" + I18n.tr("Be sure to include the following information:") + "</html>"), GBC.eol());
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), new ClipboardOwner(){

                            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                            }
                        });
                        jPanel.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)")), GBC.eop());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    JTextArea jTextArea = new JTextArea(string, 20, 60);
                    jTextArea.setCaretPosition(0);
                    jTextArea.setEditable(false);
                    jPanel.add((Component)new JScrollPane(jTextArea), GBC.eop());
                    JOptionPane.showMessageDialog(Main.parent, jPanel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

