/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DownloadAction
extends JosmAction {
    public DownloadDialog dialog;

    public DownloadAction() {
        super(I18n.tr("Download from OSM..."), "download", I18n.tr("Download map data from the OSM server."), Shortcut.registerShortcut("file:download", I18n.tr("File: {0}", I18n.tr("Download from OSM...")), 68, 8), true);
    }

    protected ExtendedDialog createUploadDialog() {
        this.dialog = new DownloadDialog();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.dialog, "Center");
        String string = this.dialog.getClass().getName() + ".geometry";
        WindowGeometry windowGeometry = WindowGeometry.centerInWindow(Main.parent, new Dimension(1000, 600));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download"), new String[]{I18n.tr("OK"), I18n.tr("Cancel")});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"ok", "cancel"});
        extendedDialog.setRememberWindowGeometry(string, windowGeometry);
        return extendedDialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ExtendedDialog extendedDialog = this.createUploadDialog();
        boolean bl = false;
        while (!bl) {
            extendedDialog.showDialog();
            Main.pref.put("download.newlayer", this.dialog.newLayer.isSelected());
            if (extendedDialog.getValue() == 1) {
                Main.pref.put("download.tab", Integer.toString(this.dialog.getSelectedTab()));
                for (DownloadDialog.DownloadTask downloadTask : this.dialog.downloadTasks) {
                    Main.pref.put("download." + downloadTask.getPreferencesSuffix(), downloadTask.getCheckBox().isSelected());
                    if (!downloadTask.getCheckBox().isSelected()) continue;
                    downloadTask.download(this, this.dialog.minlat, this.dialog.minlon, this.dialog.maxlat, this.dialog.maxlon, null);
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one task to download"), I18n.tr("Error"), 0);
        }
        this.dialog = null;
        extendedDialog.dispose();
    }
}

