/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes"), "mergenodes", I18n.tr("Merge nodes into the oldest one."), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes")), 77, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        Set<Node> set = OsmPrimitive.getFilteredSet(collection, Node.class);
        if (set.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two nodes to merge."), I18n.tr("Warning"), 2);
            return;
        }
        Node node = MergeNodesAction.selectTargetNode(set);
        Command command = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), set, node);
        if (command != null) {
            Main.main.undoRedo.add(command);
            Main.main.getEditLayer().data.setSelected(node);
        }
    }

    public static Node selectTargetNode(Collection<Node> collection) {
        Node node = null;
        for (Node node2 : collection) {
            if (node2.getId() <= 0L) continue;
            node = node2;
            break;
        }
        if (node == null) {
            node = collection.iterator().next();
        }
        return node;
    }

    public static Command mergeNodes(OsmDataLayer osmDataLayer, Collection<Node> collection, Node node) throws IllegalArgumentException {
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "nodes"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "targetNode"));
        }
        if (collection == null) {
            return null;
        }
        collection.remove(null);
        BackreferencedDataSet backreferencedDataSet = new BackreferencedDataSet(osmDataLayer.data);
        backreferencedDataSet.build();
        return MergeNodesAction.mergeNodes(osmDataLayer, backreferencedDataSet, collection, node);
    }

    protected static List<Command> fixParentWays(BackreferencedDataSet backreferencedDataSet, Collection<OsmPrimitive> collection, Node node) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : OsmPrimitive.getFilteredList(backreferencedDataSet.getParents(collection), Way.class)) {
            ArrayList<Node> arrayList2 = new ArrayList<Node>(way.getNodesCount());
            for (Node node2 : way.getNodes()) {
                if (!collection.contains(node2) && node2 != node) {
                    arrayList2.add(node2);
                    continue;
                }
                if (arrayList2.isEmpty()) {
                    arrayList2.add(node);
                    continue;
                }
                if (arrayList2.get(arrayList2.size() - 1) == node) continue;
                arrayList2.add(node);
            }
            if (arrayList2.size() < 2) {
                if (backreferencedDataSet.getParents(way).isEmpty()) {
                    hashSet.add(way);
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot merge nodes: Would have to delete a way that is still used."), I18n.tr("Warning"), 2);
                return null;
            }
            if (arrayList2.size() < 2 && backreferencedDataSet.getParents(way).isEmpty()) {
                hashSet.add(way);
                continue;
            }
            Way way2 = new Way(way);
            way2.setNodes(arrayList2);
            arrayList.add(new ChangeCommand(way, way2));
        }
        return arrayList;
    }

    public static Command mergeNodes(OsmDataLayer osmDataLayer, BackreferencedDataSet backreferencedDataSet, Collection<Node> collection, Node node) {
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "nodes"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "targetNode"));
        }
        if (collection == null) {
            return null;
        }
        if (backreferencedDataSet == null) {
            backreferencedDataSet = new BackreferencedDataSet(osmDataLayer.data);
            backreferencedDataSet.build();
        }
        Set<BackreferencedDataSet.RelationToChildReference> set = backreferencedDataSet.getRelationToChildReferences(collection);
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        TagConflictResolutionUtil.combineTigerTags(tagCollection);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(tagCollection, collection);
        TagCollection tagCollection2 = new TagCollection(tagCollection);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagCollection2);
        CombinePrimitiveResolverDialog combinePrimitiveResolverDialog = CombinePrimitiveResolverDialog.getInstance();
        combinePrimitiveResolverDialog.getTagConflictResolverModel().populate(tagCollection2, tagCollection.getKeysWithMultipleValues());
        combinePrimitiveResolverDialog.getRelationMemberConflictResolverModel().populate(set);
        combinePrimitiveResolverDialog.setTargetPrimitive(node);
        combinePrimitiveResolverDialog.prepareDefaultDecisions();
        if (!tagCollection.isApplicableToPrimitive() || set.size() > 1) {
            combinePrimitiveResolverDialog.setVisible(true);
            if (combinePrimitiveResolverDialog.isCancelled()) {
                return null;
            }
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        hashSet.remove(node);
        HashSet hashSet2 = new HashSet();
        List<Command> list = MergeNodesAction.fixParentWays(backreferencedDataSet, hashSet, node);
        if (list == null) {
            return null;
        }
        linkedList.addAll(list);
        if (!hashSet.isEmpty()) {
            linkedList.add(new DeleteCommand(hashSet));
        }
        if (!hashSet2.isEmpty()) {
            linkedList.add(new DeleteCommand(hashSet2));
        }
        linkedList.addAll(combinePrimitiveResolverDialog.buildResolutionCommands());
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Merge {0} nodes", collection.size()), linkedList);
        return sequenceCommand;
    }

    @Override
    public void updateEnabledState() {
        if (this.getCurrentDataSet() == null || this.getCurrentDataSet().getSelected().isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean bl = true;
        if (this.getCurrentDataSet().getSelected().size() < 2) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : this.getCurrentDataSet().getSelected()) {
            if (osmPrimitive instanceof Node) continue;
            bl = false;
            break;
        }
        this.setEnabled(bl);
    }
}

