/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalizeAction
extends JosmAction {
    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape"), "ortho", I18n.tr("Move nodes so all angles are 90 or 270 degree"), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape")), 81, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        LinkedList<Command> linkedList = collection.iterator();
        while (linkedList.hasNext()) {
            OsmPrimitive osmPrimitive = linkedList.next();
            if (osmPrimitive instanceof Node) {
                if (arrayList.size() == 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only two nodes allowed"), I18n.tr("Information"), 1);
                    return;
                }
                arrayList.add((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Selection must consist only of ways."), I18n.tr("Information"), 1);
                return;
            }
            Way way = (Way)osmPrimitive;
            if (way.getNodesCount() < 5 || !way.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select one or more closed ways of at least four nodes."), I18n.tr("Information"), 1);
                return;
            }
            for (n = 0; n < way.getNodesCount() - 1; ++n) {
                double d;
                int n2 = (n + 1) % (way.getNodesCount() - 1);
                int n3 = (n + 2) % (way.getNodesCount() - 1);
                double d2 = Math.abs(way.getNode(n).getEastNorth().heading(way.getNode(n2).getEastNorth()));
                double d3 = Math.abs(way.getNode(n2).getEastNorth().heading(way.getNode(n3).getEastNorth()));
                for (d = Math.abs(d3 - d2); d > Math.PI; d -= Math.PI) {
                }
                if (!(d < 0.7853981633974483)) continue;
                arrayList2.add(way.getNode(n2));
            }
            while (arrayList2.contains(way.firstNode())) {
                Node node = way.firstNode();
                way.removeNode(node);
                way.addNode(way.getNodesCount() - 2, node);
            }
        }
        if ("EPSG:4326".equals(((Object)Main.proj).toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, linkedList = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>"), I18n.tr("Warning"), 0, 3, 0)) {
            return;
        }
        if (arrayList.size() == 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only one node selected"), I18n.tr("Warning"), 2);
            return;
        }
        linkedList = new LinkedList<Command>();
        double d = 0.0;
        n = 0;
        if (arrayList.size() == 2) {
            d = OrthogonalizeAction.normalize_angle(((Node)arrayList.get(0)).getEastNorth().heading(((Node)arrayList.get(1)).getEastNorth()));
            n = 1;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            int n4;
            Object object;
            if (!(osmPrimitive instanceof Way)) continue;
            Way way = (Way)osmPrimitive;
            Way way2 = new Way();
            for (Node node : way.getNodes()) {
                if (arrayList2.contains(node)) continue;
                way2.addNode(node);
            }
            int n5 = way2.getNodesCount();
            int n6 = n5 - 1;
            EastNorth[] eastNorthArray = new EastNorth[n6];
            for (int i = 0; i < n6; ++i) {
                eastNorthArray[i] = new EastNorth(way2.getNode(i).getEastNorth().east(), way2.getNode(i).getEastNorth().north());
            }
            if (n == 0) {
                int n7;
                double[] dArray = new double[n6];
                object = new double[n6];
                for (int i = 0; i < n6; ++i) {
                    dArray[i] = OrthogonalizeAction.normalize_angle(way2.getNode(i).getEastNorth().heading(way2.getNode(i + 1).getEastNorth()));
                    object[i] = way2.getNode(i).getEastNorth().distance(way2.getNode(i + 1).getEastNorth());
                }
                double d4 = 0.0;
                for (n7 = 0; n7 < n6; ++n7) {
                    double d5 = 0.0;
                    d5 = n7 == 0 ? OrthogonalizeAction.heading_diff(dArray[n7], dArray[n6 - 1]) : OrthogonalizeAction.heading_diff(dArray[n7], dArray[n7 - 1]);
                    if (!(d5 > d4)) continue;
                    d4 = d5;
                }
                if (d4 > 1.0471975511965976) {
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (!(dArray[n7] < 0.0)) continue;
                        int n8 = n7;
                        dArray[n8] = dArray[n8] + 1.5707963267948966;
                    }
                }
                double d6 = 0.0;
                double d7 = 0.0;
                for (n4 = 0; n4 < n6; ++n4) {
                    d6 += dArray[n4] * object[n4];
                    d7 += object[n4];
                }
                d = OrthogonalizeAction.normalize_angle(d6 / d7);
            }
            double[] dArray = null;
            object = null;
            Object object2 = null;
            Node node = null;
            Node node2 = null;
            Node node3 = null;
            for (int i = 0; i < n6; ++i) {
                int n9 = i;
                n4 = (i + 1) % n6;
                int n10 = (i + 2) % n6;
                double d8 = OrthogonalizeAction.normalize_angle(eastNorthArray[n9].heading(eastNorthArray[n4]), d);
                double d9 = d - d8;
                double d10 = OrthogonalizeAction.normalize_angle(eastNorthArray[n4].heading(eastNorthArray[n10]), d);
                double d11 = d - d10;
                EastNorth eastNorth = new EastNorth((eastNorthArray[n9].east() + eastNorthArray[n4].east()) / 2.0, (eastNorthArray[n9].north() + eastNorthArray[n4].north()) / 2.0);
                EastNorth eastNorth2 = eastNorthArray[n9].rotate(eastNorth, d9);
                EastNorth eastNorth3 = eastNorthArray[n4].rotate(eastNorth, d9);
                EastNorth eastNorth4 = new EastNorth((eastNorthArray[n4].east() + eastNorthArray[n10].east()) / 2.0, (eastNorthArray[n4].north() + eastNorthArray[n10].north()) / 2.0);
                EastNorth eastNorth5 = eastNorthArray[n4].rotate(eastNorth4, d11);
                EastNorth eastNorth6 = eastNorthArray[n10].rotate(eastNorth4, d11);
                double d12 = OrthogonalizeAction.det(eastNorth3.east() - eastNorth2.east(), eastNorth3.north() - eastNorth2.north(), eastNorth5.east() - eastNorth6.east(), eastNorth5.north() - eastNorth6.north());
                if (d12 == 0.0) continue;
                double d13 = OrthogonalizeAction.det(eastNorth3.north() - eastNorth5.north(), eastNorth3.east() - eastNorth5.east(), eastNorth6.north() - eastNorth5.north(), eastNorth6.east() - eastNorth5.east()) / d12;
                EastNorth eastNorth7 = new EastNorth(eastNorth3.east() + d13 * (eastNorth2.east() - eastNorth3.east()), eastNorth3.north() + d13 * (eastNorth2.north() - eastNorth3.north()));
                Node node4 = way2.getNode(n4);
                LatLon latLon = Main.proj.eastNorth2latlon(eastNorth7);
                if (!latLon.equalsEpsilon(node4.getCoor())) {
                    double d14 = eastNorth7.east() - node4.getEastNorth().east();
                    double d15 = eastNorth7.north() - node4.getEastNorth().north();
                    linkedList.add(new MoveCommand(node4, d14, d15));
                }
                dArray = object;
                object = eastNorth7;
                node = node2;
                node2 = node4;
                if (dArray != null) {
                    MoveCommand moveCommand = this.alignSide(this.findNodesToAlign(way, node, node2), (EastNorth)dArray, (EastNorth)object);
                    if (moveCommand == null) continue;
                    linkedList.add(moveCommand);
                    continue;
                }
                object2 = object;
                node3 = node2;
            }
            MoveCommand moveCommand = this.alignSide(this.findNodesToAlign(way, node2, node3), (EastNorth)object, (EastNorth)object2);
            if (moveCommand == null) continue;
            linkedList.add(moveCommand);
        }
        if (linkedList.size() > 0) {
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize"), linkedList));
            Main.map.repaint();
        }
    }

    private MoveCommand alignSide(ArrayList<Node> arrayList, EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east();
        double d2 = eastNorth.north();
        double d3 = eastNorth2.east();
        double d4 = eastNorth2.north();
        Iterator<Node> iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            double d5 = node.getEastNorth().east();
            double d6 = node.getEastNorth().north();
            if (d == d3) {
                d5 = d;
            } else if (d2 == d4) {
                d6 = d2;
            } else {
                double d7 = (d4 - d2) / (d3 - d);
                double d8 = d2 - d * d7;
                double d9 = -1.0 / d7;
                double d10 = node.getEastNorth().north() - node.getEastNorth().east() * d9;
                d5 = (d10 - d8) / (d7 - d9);
                d6 = d7 * d5 + d8;
            }
            return new MoveCommand(node, d5 - node.getEastNorth().east(), d6 - node.getEastNorth().north());
        }
        return null;
    }

    private ArrayList<Node> findNodesToAlign(Way way, Node node, Node node2) {
        Node node3;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = false;
        for (int i = 0; i < way.getNodesCount() && !(node3 = way.getNode(i % way.getNodesCount())).equals(node2); ++i) {
            if (bl) {
                arrayList.add(node3);
            }
            if (!node3.equals(node)) continue;
            bl = true;
        }
        return arrayList;
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    static double normalize_angle(double d) {
        return OrthogonalizeAction.normalize_angle(d, 0.0);
    }

    static double normalize_angle(double d, double d2) {
        double d3 = -0.7853981633974483;
        double d4 = 0.7853981633974483;
        while (d - d2 > d4) {
            d -= 1.5707963267948966;
        }
        while (d - d2 < d3) {
            d += 1.5707963267948966;
        }
        return d;
    }

    static double heading_diff(double d, double d2) {
        double d3 = d > d2 ? d - d2 : d2 - d;
        return d3;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

