/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasteTagsAction
extends JosmAction {
    private static List<Class<? extends OsmPrimitive>> osmPrimitiveClasses = new ArrayList<Class<? extends OsmPrimitive>>();

    public PasteTagsAction(JosmAction josmAction) {
        super(I18n.tr("Paste Tags"), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items."), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags")), 86, 2, 1), true);
        josmAction.addListener(this);
    }

    protected boolean isHeteogeneousSource() {
        int n = 0;
        n = !this.getSourcePrimitivesByType(Node.class).isEmpty() ? n + 1 : n;
        n = !this.getSourcePrimitivesByType(Way.class).isEmpty() ? n + 1 : n;
        n = !this.getSourcePrimitivesByType(Relation.class).isEmpty() ? n + 1 : n;
        return n > 1;
    }

    protected <T extends OsmPrimitive> Collection<? extends OsmPrimitive> getSourcePrimitivesByType(Class<T> clazz) {
        return OsmPrimitive.getFilteredList(Main.pasteBuffer.getSelected(), clazz);
    }

    protected <T extends OsmPrimitive> TagCollection getSourceTagsByType(Class<T> clazz) {
        return TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(clazz));
    }

    protected <T extends OsmPrimitive> boolean hasSourceTagsByType(Class<T> clazz) {
        return !this.getSourceTagsByType(clazz).isEmpty();
    }

    protected Command buildChangeCommand(Collection<? extends OsmPrimitive> collection, TagCollection tagCollection) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (String string : tagCollection.getKeys()) {
            String string2 = tagCollection.getValues(string).iterator().next();
            string2 = string2.equals("") ? null : string2;
            arrayList.add(new ChangePropertyCommand(collection, string, string2));
        }
        if (!arrayList.isEmpty()) {
            String string;
            String string3 = I18n.trn("Pasting {0} tag", "Pasting {0} tags", tagCollection.getKeys().size(), tagCollection.getKeys().size());
            string = I18n.trn("to {0} primitive", "to {0} primtives", collection.size(), collection.size());
            return new SequenceCommand((String)string3 + " " + string, arrayList);
        }
        return null;
    }

    protected Map<OsmPrimitiveType, Integer> getSourceStatistics() {
        HashMap<OsmPrimitiveType, Integer> hashMap = new HashMap<OsmPrimitiveType, Integer>();
        for (Class<? extends OsmPrimitive> clazz : osmPrimitiveClasses) {
            if (this.getSourceTagsByType(clazz).isEmpty()) continue;
            hashMap.put(OsmPrimitiveType.from(clazz), this.getSourcePrimitivesByType(clazz).size());
        }
        return hashMap;
    }

    protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
        HashMap<OsmPrimitiveType, Integer> hashMap = new HashMap<OsmPrimitiveType, Integer>();
        for (Class<? extends OsmPrimitive> clazz : osmPrimitiveClasses) {
            int n = OsmPrimitive.getFilteredList(this.getEditLayer().data.getSelected(), clazz).size();
            if (n <= 0) continue;
            hashMap.put(OsmPrimitiveType.from(clazz), n);
        }
        return hashMap;
    }

    protected void pasteFromHomogeneousSource(Collection<? extends OsmPrimitive> collection) {
        Object object;
        TagCollection tagCollection = null;
        for (Class<? extends OsmPrimitive> clazz : osmPrimitiveClasses) {
            TagCollection tagCollection2 = this.getSourceTagsByType(clazz);
            if (tagCollection2.isEmpty()) continue;
            tagCollection = tagCollection2;
        }
        if (tagCollection == null) {
            return;
        }
        if (!tagCollection.isApplicableToPrimitive()) {
            Class<? extends OsmPrimitive> clazz;
            object = new PasteTagsConflictResolverDialog(Main.parent);
            ((PasteTagsConflictResolverDialog)object).populate(tagCollection, this.getSourceStatistics(), this.getTargetStatistics());
            ((PasteTagsConflictResolverDialog)object).setVisible(true);
            if (((PasteTagsConflictResolverDialog)object).isCanceled()) {
                return;
            }
            clazz = this.buildChangeCommand(collection, ((PasteTagsConflictResolverDialog)object).getResolution());
            Main.main.undoRedo.add((Command)((Object)clazz));
        } else {
            object = this.buildChangeCommand(collection, tagCollection);
            Main.main.undoRedo.add((Command)object);
        }
    }

    protected <T extends OsmPrimitive> boolean hasTargetPrimitives(Collection<OsmPrimitive> collection, Class<T> clazz) {
        return !OsmPrimitive.getFilteredList(collection, clazz).isEmpty();
    }

    protected boolean canPasteFromHeterogeneousSourceWithoutConflict(Collection<OsmPrimitive> collection) {
        TagCollection tagCollection;
        if (this.hasTargetPrimitives(collection, Node.class) && !(tagCollection = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(Node.class))).isEmpty() && !tagCollection.isApplicableToPrimitive()) {
            return false;
        }
        if (this.hasTargetPrimitives(collection, Way.class) && !(tagCollection = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(Way.class))).isEmpty() && !tagCollection.isApplicableToPrimitive()) {
            return false;
        }
        return !this.hasTargetPrimitives(collection, Relation.class) || (tagCollection = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(Relation.class))).isEmpty() || tagCollection.isApplicableToPrimitive();
    }

    protected void pasteFromHeterogeneousSource(Collection<OsmPrimitive> collection) {
        if (this.canPasteFromHeterogeneousSourceWithoutConflict(collection)) {
            Command command;
            if (this.hasSourceTagsByType(Node.class) && this.hasTargetPrimitives(collection, Node.class)) {
                command = this.buildChangeCommand(collection, this.getSourceTagsByType(Node.class));
                Main.main.undoRedo.add(command);
            }
            if (this.hasSourceTagsByType(Way.class) && this.hasTargetPrimitives(collection, Way.class)) {
                command = this.buildChangeCommand(collection, this.getSourceTagsByType(Way.class));
                Main.main.undoRedo.add(command);
            }
            if (this.hasSourceTagsByType(Relation.class) && this.hasTargetPrimitives(collection, Relation.class)) {
                command = this.buildChangeCommand(collection, this.getSourceTagsByType(Relation.class));
                Main.main.undoRedo.add(command);
            }
        } else {
            Command command;
            PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
            pasteTagsConflictResolverDialog.populate(this.getSourceTagsByType(Node.class), this.getSourceTagsByType(Way.class), this.getSourceTagsByType(Relation.class), this.getSourceStatistics(), this.getTargetStatistics());
            pasteTagsConflictResolverDialog.setVisible(true);
            if (pasteTagsConflictResolverDialog.isCanceled()) {
                return;
            }
            if (this.hasSourceTagsByType(Node.class) && this.hasTargetPrimitives(collection, Node.class)) {
                command = this.buildChangeCommand(OsmPrimitive.getFilteredList(collection, Node.class), pasteTagsConflictResolverDialog.getResolution(OsmPrimitiveType.NODE));
                Main.main.undoRedo.add(command);
            }
            if (this.hasSourceTagsByType(Way.class) && this.hasTargetPrimitives(collection, Way.class)) {
                command = this.buildChangeCommand(OsmPrimitive.getFilteredList(collection, Way.class), pasteTagsConflictResolverDialog.getResolution(OsmPrimitiveType.WAY));
                Main.main.undoRedo.add(command);
            }
            if (this.hasSourceTagsByType(Relation.class) && this.hasTargetPrimitives(collection, Relation.class)) {
                command = this.buildChangeCommand(OsmPrimitive.getFilteredList(collection, Relation.class), pasteTagsConflictResolverDialog.getResolution(OsmPrimitiveType.RELATION));
                Main.main.undoRedo.add(command);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getCurrentDataSet().getSelected().isEmpty()) {
            return;
        }
        if (this.isHeteogeneousSource()) {
            this.pasteFromHeterogeneousSource(this.getCurrentDataSet().getSelected());
        } else {
            this.pasteFromHomogeneousSource(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void pasteBufferChanged(DataSet dataSet) {
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!this.getCurrentDataSet().getSelected().isEmpty() && !TagCollection.unionOfAllPrimitives(Main.pasteBuffer.getSelected()).isEmpty());
    }

    static {
        osmPrimitiveClasses.add(Node.class);
        osmPrimitiveClasses.add(Way.class);
        osmPrimitiveClasses.add(Relation.class);
    }
}

