/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways"), "wayflip", I18n.tr("Reverse the direction of all selected ways."), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways")), 82, 3), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentDataSet() == null) {
            return;
        }
        LinkedList<Way> linkedList = new LinkedList<Way>();
        for (OsmPrimitive object2 : this.getCurrentDataSet().getSelected()) {
            if (!(object2 instanceof Way)) continue;
            linkedList.add((Way)object2);
        }
        if (linkedList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one way."), I18n.tr("Information"), 1);
            return;
        }
        boolean bl = false;
        ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        for (Way way : linkedList) {
            Way way2 = new Way(way);
            List<Node> list = way2.getNodes();
            Collections.reverse(list);
            way2.setNodes(list);
            if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                try {
                    Collection<Command> userCancelException = reverseWayTagCorrector.execute(way, way2);
                    bl = bl || userCancelException != null && !userCancelException.isEmpty();
                    linkedList2.addAll(userCancelException);
                }
                catch (UserCancelException userCancelException) {
                    return;
                }
            }
            linkedList2.add(new ChangeCommand(way, way2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways"), linkedList2));
        if (bl) {
            DataSet.fireSelectionChanged(this.getCurrentDataSet().getSelected());
        }
        Main.map.repaint();
    }

    protected int getNumWaysInSelection() {
        if (this.getCurrentDataSet() == null) {
            return 0;
        }
        int n = 0;
        for (OsmPrimitive osmPrimitive : this.getCurrentDataSet().getSelected()) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        return n;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getNumWaysInSelection() > 0);
    }
}

