/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data"), "updatedata", I18n.tr("Updates the objects in the current data layer from the server."), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update data"), 85, 1), true);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getEditLayer() == null) {
            return;
        }
        int n2 = 0;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (DataSource dataSource : this.getEditLayer().data.dataSources) {
            arrayList.add(new Area(dataSource.bounds.asRect()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            for (int i = n - 1; i > 0; --i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (Area area : arrayList) {
            if (area.isEmpty()) continue;
            ++n2;
        }
        if (n2 == 0) {
            new UpdateSelectionAction().updatePrimitives(this.getEditLayer().data.allPrimitives());
        } else {
            new DownloadOsmTaskList().download(false, (Collection<Area>)arrayList, (ProgressMonitor)new PleaseWaitProgressMonitor(I18n.tr("Updating data")));
        }
    }
}

