/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.UploadParameterHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangesetCloseException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadAction
extends JosmAction {
    private static Logger logger = Logger.getLogger(UploadAction.class.getName());
    private static final LinkedList<UploadHook> uploadHooks = new LinkedList();

    public static void registerUploadHook(UploadHook uploadHook) {
        if (uploadHook == null) {
            return;
        }
        if (!uploadHooks.contains(uploadHook)) {
            uploadHooks.add(0, uploadHook);
        }
    }

    public static void unregisterUploadHook(UploadHook uploadHook) {
        if (uploadHook == null) {
            return;
        }
        if (uploadHooks.contains(uploadHook)) {
            uploadHooks.remove(uploadHook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data"), "upload", I18n.tr("Upload all changes in the current data layer to the OSM server"), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data")), 85, 8), true);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public boolean checkPreUploadConditions(OsmDataLayer osmDataLayer) {
        return this.checkPreUploadConditions(osmDataLayer, new APIDataSet(osmDataLayer.data));
    }

    public boolean checkPreUploadConditions(OsmDataLayer osmDataLayer, APIDataSet aPIDataSet) {
        ConflictCollection conflictCollection = osmDataLayer.getConflicts();
        if (conflictCollection != null && !conflictCollection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>There are unresolved conflicts in layer ''{0}''.<br>You have to resolve them first.</html>", osmDataLayer.getName()), I18n.tr("Warning"), 2);
            return false;
        }
        for (UploadHook uploadHook : uploadHooks) {
            if (uploadHook.checkUpload(aPIDataSet)) continue;
            return false;
        }
        return true;
    }

    public void uploadData(OsmDataLayer osmDataLayer, APIDataSet aPIDataSet) {
        if (aPIDataSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."), I18n.tr("Warning"), 1);
            return;
        }
        if (!this.checkPreUploadConditions(osmDataLayer, aPIDataSet)) {
            return;
        }
        Main.worker.execute(this.createUploadTask(osmDataLayer, aPIDataSet.getPrimitives(), UploadDialog.getUploadDialog().getChangeset(), UploadDialog.getUploadDialog().isDoCloseAfterUpload()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first."), I18n.tr("Warning"), 2);
            return;
        }
        APIDataSet aPIDataSet = new APIDataSet(Main.main.getCurrentDataSet());
        this.uploadData(Main.map.mapView.getEditLayer(), aPIDataSet);
    }

    protected void synchronizePrimitive(OsmPrimitiveType osmPrimitiveType, long l) {
        Main.worker.execute(new UpdatePrimitiveTask(osmPrimitiveType, l));
    }

    protected void synchronizeDataSet() {
        UpdateDataAction updateDataAction = new UpdateDataAction();
        updateDataAction.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(OsmPrimitiveType osmPrimitiveType, long l, String string, String string2) {
        String string3 = "";
        switch (osmPrimitiveType) {
            case NODE: {
                string3 = I18n.tr("Synchronize node {0} only", l);
                break;
            }
            case WAY: {
                string3 = I18n.tr("Synchronize way {0} only", l);
                break;
            }
            case RELATION: {
                string3 = I18n.tr("Synchronize relation {0} only", l);
            }
        }
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(string3, ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String string4 = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(osmPrimitiveType.getAPIName()), l, string, string2, buttonSpecArray[0].text, buttonSpecArray[1].text, buttonSpecArray[2].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string4, I18n.tr("Conflicts detected"), 0, null, buttonSpecArray, buttonSpecArray[0], "Concepts/Conflict");
        switch (n) {
            case 0: {
                this.synchronizePrimitive(osmPrimitiveType, l);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", buttonSpecArray[0].text, buttonSpecArray[1].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Conflicts detected"), 0, null, buttonSpecArray, buttonSpecArray[0], "Concepts/Conflict");
        if (n == 0) {
            this.synchronizeDataSet();
        }
    }

    protected void handleUploadConflictForClosedChangeset(long l, Date date) {
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because you''ve been using<br>changeset {0} which was already closed at {1}.<br>Please upload again with a new or an existing open changeset.</html>", l, new SimpleDateFormat().format(date));
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Changeset closed"), 0);
    }

    protected void handleUploadConflict(OsmApiException osmApiException) {
        String string = "Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(osmApiException.getErrorHeader());
        if (matcher.matches()) {
            this.handleUploadConflictForKnownConflict(OsmPrimitiveType.from(matcher.group(3)), Long.parseLong(matcher.group(4)), matcher.group(2), matcher.group(1));
            return;
        }
        string = "The changeset (\\d+) was closed at (.*)";
        pattern = Pattern.compile(string);
        matcher = pattern.matcher(osmApiException.getErrorHeader());
        if (matcher.matches()) {
            this.handleUploadConflictForClosedChangeset(Long.parseLong(matcher.group(1)), DateUtils.fromString(matcher.group(2)));
            return;
        }
        logger.warning(I18n.tr("Warning: error header \"{0}\" did not match expected pattern \"{1}\"", osmApiException.getErrorHeader(), string));
        this.handleUploadConflictForUnknownConflict();
    }

    protected void handleGoneForKnownPrimitive(OsmPrimitiveType osmPrimitiveType, long l) {
        UpdateSelectionAction updateSelectionAction = new UpdateSelectionAction();
        updateSelectionAction.handlePrimitiveGoneException(l, osmPrimitiveType);
    }

    protected void handleGone(OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) {
        if (osmApiPrimitiveGoneException.isKnownPrimitive()) {
            this.handleGoneForKnownPrimitive(osmApiPrimitiveGoneException.getPrimitiveType(), osmApiPrimitiveGoneException.getPrimitiveId());
        } else {
            ExceptionDialogUtil.explainGoneForUnknownPrimitive(osmApiPrimitiveGoneException);
        }
    }

    protected void handleFailedUpload(Exception exception) {
        if (exception instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)exception);
            return;
        }
        if (exception instanceof OsmChangesetCloseException) {
            ExceptionDialogUtil.explainOsmChangesetCloseException((OsmChangesetCloseException)exception);
            return;
        }
        if (exception instanceof OsmApiPrimitiveGoneException) {
            this.handleGone((OsmApiPrimitiveGoneException)exception);
            return;
        }
        if (exception instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)exception;
            if (osmApiException.getResponseCode() == 409) {
                this.handleUploadConflict(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 412) {
                ExceptionDialogUtil.explainPreconditionFailed(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(osmApiException);
                return;
            }
            osmApiException.printStackTrace();
            String string = I18n.tr("<html>Uploading <strong>failed</strong>.<br>{0}</html>", osmApiException.getDisplayMessage());
            JOptionPane.showMessageDialog(Main.map, string, I18n.tr("Upload to OSM API failed"), 0);
            return;
        }
        ExceptionDialogUtil.explainException(exception);
    }

    public UploadPrimitivesTask createUploadTask(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, Changeset changeset, boolean bl) {
        return new UploadPrimitivesTask(osmDataLayer, collection, changeset, bl);
    }

    static {
        uploadHooks.add(new ApiPreconditionCheckerHook());
        uploadHooks.add(new RelationUploadOrderHook());
        uploadHooks.add(new UploadParameterHook());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UploadPrimitivesTask
    extends PleaseWaitRunnable {
        private boolean uploadCancelled;
        private Exception lastException;
        private Collection<OsmPrimitive> toUpload;
        private OsmServerWriter writer;
        private OsmDataLayer layer;
        private Changeset changeset;
        private boolean closeChangesetAfterUpload;
        private HashSet<OsmPrimitive> processedPrimitives;

        private UploadPrimitivesTask(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, Changeset changeset, boolean bl) {
            super(I18n.tr("Uploading data for layer ''{0}''", osmDataLayer.getName()), false);
            this.uploadCancelled = false;
            this.lastException = null;
            this.toUpload = collection;
            this.layer = osmDataLayer;
            this.changeset = changeset;
            this.closeChangesetAfterUpload = bl;
            this.processedPrimitives = new HashSet();
        }

        protected OsmPrimitive getPrimitive(OsmPrimitiveType osmPrimitiveType, long l) {
            for (OsmPrimitive osmPrimitive : this.toUpload) {
                if (!OsmPrimitiveType.from(osmPrimitive).equals((Object)osmPrimitiveType) || osmPrimitive.getId() != l) continue;
                return osmPrimitive;
            }
            return null;
        }

        protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException osmApiPrimitiveGoneException, ProgressMonitor progressMonitor) throws OsmTransferException {
            if (!osmApiPrimitiveGoneException.isKnownPrimitive()) {
                throw osmApiPrimitiveGoneException;
            }
            OsmPrimitive osmPrimitive = this.getPrimitive(osmApiPrimitiveGoneException.getPrimitiveType(), osmApiPrimitiveGoneException.getPrimitiveId());
            if (osmPrimitive == null) {
                throw osmApiPrimitiveGoneException;
            }
            if (osmPrimitive.isDeleted()) {
                System.out.println(I18n.tr("Warning: primitive ''{0}'' is already deleted on the server. Skipping this primitive and retrying to upload.", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
                this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                this.processedPrimitives.add(osmPrimitive);
                this.toUpload.removeAll(this.processedPrimitives);
                return;
            }
            throw osmApiPrimitiveGoneException;
        }

        @Override
        protected void realRun() throws SAXException, IOException {
            this.writer = new OsmServerWriter();
            try {
                while (true) {
                    try {
                        ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                        this.writer.uploadOsm(this.layer.data.version, this.toUpload, this.changeset, progressMonitor);
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    catch (OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) {
                        this.recoverFromGoneOnServer(osmApiPrimitiveGoneException, this.getProgressMonitor());
                        continue;
                    }
                    break;
                }
                if (this.closeChangesetAfterUpload && this.changeset != null && this.changeset.getId() > 0L) {
                    OsmApi.getOsmApi().closeChangeset(this.changeset, this.progressMonitor.createSubTaskMonitor(0, false));
                }
            }
            catch (Exception exception) {
                if (this.uploadCancelled) {
                    System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + exception.toString());
                    return;
                }
                this.lastException = exception;
            }
        }

        @Override
        protected void finish() {
            if (this.uploadCancelled) {
                return;
            }
            this.layer.cleanupAfterUpload(this.processedPrimitives);
            DataSet.fireSelectionChanged(this.layer.data.getSelected());
            this.layer.fireDataChange();
            if (this.lastException != null) {
                UploadAction.this.handleFailedUpload(this.lastException);
            }
            this.layer.onPostUploadToServer();
            UploadDialog.getUploadDialog().setOrUpdateChangeset(this.changeset);
        }

        @Override
        protected void cancel() {
            this.uploadCancelled = true;
            if (this.writer != null) {
                this.writer.cancel();
            }
        }
    }

    class UpdatePrimitiveTask
    extends PleaseWaitRunnable {
        private boolean uploadCancelled;
        private boolean uploadFailed;
        private Exception lastException;
        private long id;
        private OsmPrimitiveType type;

        public UpdatePrimitiveTask(OsmPrimitiveType osmPrimitiveType, long l) {
            super(I18n.tr("Updating primitive"), false);
            this.uploadCancelled = false;
            this.uploadFailed = false;
            this.lastException = null;
            this.id = l;
            this.type = osmPrimitiveType;
        }

        protected void realRun() throws SAXException, IOException {
            try {
                UpdateSelectionAction updateSelectionAction = new UpdateSelectionAction();
                updateSelectionAction.updatePrimitive(this.type, this.id);
            }
            catch (Exception exception) {
                if (this.uploadCancelled) {
                    System.out.println("Ignoring exception caught because upload is canceled. Exception is: " + exception.toString());
                    return;
                }
                this.uploadFailed = true;
                this.lastException = exception;
            }
        }

        protected void finish() {
            if (this.uploadFailed) {
                UploadAction.this.handleFailedUpload(this.lastException);
            }
        }

        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.uploadCancelled = true;
        }
    }
}

