/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList
implements Runnable {
    private List<DownloadDialog.DownloadTask> osmTasks = new LinkedList<DownloadDialog.DownloadTask>();
    private ProgressMonitor progressMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(boolean bl, List<Rectangle2D> list, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (bl) {
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
            Main.map.mapView.setActiveLayer(osmDataLayer);
        }
        progressMonitor.beginTask(null, list.size());
        try {
            int n = 0;
            for (Rectangle2D rectangle2D : list) {
                DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
                ProgressMonitor progressMonitor2 = progressMonitor.createSubTaskMonitor(1, false);
                progressMonitor2.setSilent(true);
                progressMonitor2.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", ++n, list.size(), list.size() - n));
                downloadOsmTask.download(null, rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX(), progressMonitor2);
                this.osmTasks.add(downloadOsmTask);
            }
        }
        finally {
            Main.worker.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(boolean bl, Collection<Area> collection, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data"));
        try {
            LinkedList<Rectangle2D> linkedList = new LinkedList<Rectangle2D>();
            for (Area area : collection) {
                linkedList.add(area.getBounds2D());
            }
            this.download(bl, (List<Rectangle2D>)linkedList, progressMonitor.createSubTaskMonitor(-1, false));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public void run() {
        Object object;
        this.progressMonitor.finishTask();
        String string = "";
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (DownloadDialog.DownloadTask object2 : this.osmTasks) {
            object = object2.getErrorMessage();
            if (((String)object).equals("") || linkedList.contains(((String)object).hashCode())) continue;
            linkedList.add(((String)object).hashCode());
            string = string + "<br>* " + object;
        }
        if (!string.equals("")) {
            JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("The following errors occurred during mass download:{0}", string) + "</html>", I18n.tr("Errors during Download"), 0);
            return;
        }
        for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
            if (!(downloadTask instanceof DownloadOsmTask) || !((DownloadOsmTask)(object = (DownloadOsmTask)downloadTask)).isCanceled() && !((DownloadOsmTask)object).isFailed()) continue;
            return;
        }
        OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
        if (osmDataLayer != null) {
            Set<OsmPrimitive> set = this.getCompletePrimitives(osmDataLayer.data);
            for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
                DataSet dataSet;
                if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
                set.removeAll(dataSet.nodes);
                set.removeAll(dataSet.ways);
                set.removeAll(dataSet.relations);
            }
            if (!set.isEmpty()) {
                this.handlePotentiallyDeletedPrimitives(set);
            }
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet dataSet) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Node osmPrimitive : dataSet.nodes) {
            if (osmPrimitive.incomplete || osmPrimitive.getId() != 0L) continue;
            hashSet.add(osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (way.incomplete || way.getId() != 0L) continue;
            hashSet.add(way);
        }
        for (Relation relation : dataSet.relations) {
            if (relation.incomplete || relation.getId() != 0L) continue;
            hashSet.add(relation);
        }
        return hashSet;
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : set) {
            if (osmPrimitive == null) continue;
            arrayList.add(osmPrimitive);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UpdateSelectionAction().updatePrimitives(arrayList);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        Object[] objectArray = new String[]{"Check on the server", "Ignore"};
        String string = I18n.tr("<html>There are {0} primitives in your local dataset which<br>might be deleted on the server. If you later try to delete or<br>update them the server is likely to report a<br>conflict.<br><br>Click <strong>{1}</strong> to check the state of these primitives<br>on the server.<br>Click <strong>{2}</strong> to ignore.<br></html>", set.size(), objectArray[0], objectArray[1]);
        int n = JOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Deleted or moved primitives"), 0, 2, null, objectArray, objectArray[0]);
        switch (n) {
            case -1: {
                return;
            }
            case 1: {
                return;
            }
            case 0: {
                this.updatePotentiallyDeletedPrimitives(set);
            }
        }
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
            DataSet dataSet;
            if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
            hashSet.addAll(dataSet.nodes);
            hashSet.addAll(dataSet.ways);
            hashSet.addAll(dataSet.relations);
        }
        return hashSet;
    }
}

