/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements AWTEventListener {
    private boolean drawTargetCursor;
    private MouseEvent oldEvent = null;
    private Cursors currCursor = Cursors.none;

    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode"), "delete", I18n.tr("Delete nodes or ways."), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete")), 68, 3), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.currCursor = Cursors.none;
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.doActionPerformed(actionEvent);
    }

    public void doActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (actionEvent.getModifiers() & 0x28) != 0;
        Command command = bl2 ? DeleteCommand.deleteWithReferences(this.getEditLayer(), this.getCurrentDataSet().getSelected()) : DeleteCommand.delete(this.getEditLayer(), this.getCurrentDataSet().getSelected(), !bl);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
        Main.map.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.oldEvent = mouseEvent;
        this.updateCursor(mouseEvent, mouseEvent.getModifiers());
    }

    private void updateCursor(MouseEvent mouseEvent, int n) {
        if (!Main.map.mapView.isActiveLayerVisible() || mouseEvent == null) {
            return;
        }
        Command command = this.buildDeleteCommands(mouseEvent, n, true);
        if (command == null) {
            this.setCursor(Cursors.none);
            return;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>();
        command.fillModifiedData(hashSet2, hashSet, hashSet);
        if (hashSet.size() == 0 && hashSet2.size() == 0) {
            this.setCursor(Cursors.none);
            return;
        }
        if (hashSet.size() == 0) {
            this.setCursor(Cursors.segment);
        } else if (hashSet.size() == 1 && hashSet.toArray()[0] instanceof Node) {
            this.setCursor(Cursors.node);
        } else if (hashSet.size() == 1 && hashSet.toArray()[0] instanceof Way) {
            this.setCursor(Cursors.way_only);
        } else {
            boolean bl;
            boolean bl2 = bl = (n & 2) != 0;
            if (bl) {
                this.setCursor(Cursors.way_node_only);
            } else {
                this.setCursor(Cursors.way_normal);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command command = this.buildDeleteCommands(mouseEvent, mouseEvent.getModifiers(), false);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: don't delete unused nodes when deleting a way. Ctrl: delete referring objects.");
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer osmDataLayer, Relation relation) {
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "toDelete"));
        }
        Command command = DeleteCommand.delete(osmDataLayer, Collections.singleton(relation));
        if (command != null) {
            Main.main.undoRedo.add(command);
            RelationDialogManager.getRelationDialogManager().close(osmDataLayer, relation);
            osmDataLayer.fireDataChange();
        }
    }

    private Command buildDeleteCommands(MouseEvent mouseEvent, int n, boolean bl) {
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 1) != 0;
        boolean bl4 = (n & 0x28) != 0;
        Node node = Main.map.mapView.getNearestNode(mouseEvent.getPoint());
        Command command = null;
        if (node == null) {
            WaySegment waySegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint());
            if (waySegment != null) {
                command = bl3 ? DeleteCommand.deleteWaySegment(this.getEditLayer(), waySegment) : (bl2 ? DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(waySegment.way), true) : DeleteCommand.delete(this.getEditLayer(), Collections.singleton(waySegment.way), !bl4, bl));
            }
        } else {
            command = bl2 ? DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(node)) : DeleteCommand.delete(this.getEditLayer(), Collections.singleton(node), !bl4, bl);
        }
        return command;
    }

    private void setCursor(final Cursors cursors) {
        if (this.currCursor.equals((Object)cursors) || !this.drawTargetCursor && this.currCursor.equals((Object)Cursors.none)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!(Main.map.mapMode instanceof DeleteAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(cursors.cursor());
                }
            });
            this.currCursor = cursors;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        this.updateCursor(this.oldEvent, ((InputEvent)aWTEvent).getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cursors {
        none,
        node,
        segment,
        way_node_only,
        way_normal,
        way_only;

        private Cursor c = null;

        public Cursor cursor() {
            if (this.c == null) {
                String string = "delete_" + this.name().toLowerCase();
                string = string.equals("delete_none") ? "delete" : string;
                this.c = ImageProvider.getCursor("normal", string);
            }
            return this.c;
        }
    }
}

