/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final String key;
    private final String value;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.key = string;
        this.value = string2;
        if (string2 == null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.get(string) == null) continue;
                this.objects.add(osmPrimitive);
            }
        } else {
            for (OsmPrimitive osmPrimitive : collection) {
                String string3 = osmPrimitive.get(string);
                if (string3 != null && string2.equals(string3)) continue;
                this.objects.add(osmPrimitive);
            }
        }
    }

    public ChangePropertyCommand(OsmPrimitive osmPrimitive, String string, String string2) {
        this.key = string;
        this.value = string2;
        String string3 = osmPrimitive.get(string);
        if (string2 == null && string3 != null || string2 != null && (string3 == null || !string2.equals(string3))) {
            this.objects.add(osmPrimitive);
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.value == null) {
            for (OsmPrimitive osmPrimitive : this.objects) {
                osmPrimitive.setModified(true);
                osmPrimitive.remove(this.key);
            }
        } else {
            for (OsmPrimitive osmPrimitive : this.objects) {
                osmPrimitive.setModified(true);
                osmPrimitive.put(this.key, this.value);
            }
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public MutableTreeNode description() {
        String string;
        Object object;
        if (this.objects.size() == 1) {
            object = this.objects.iterator().next();
            Object object2 = "";
            if (this.value == null) {
                switch (OsmPrimitiveType.from((OsmPrimitive)object)) {
                    case NODE: {
                        object2 = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        object2 = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        object2 = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                    }
                }
                string = I18n.tr((String)object2, this.key, ((OsmPrimitive)object).getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                switch (OsmPrimitiveType.from((OsmPrimitive)object)) {
                    case NODE: {
                        object2 = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        object2 = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        object2 = I18n.marktr("Set {0}={1} for relation ''{2}''");
                    }
                }
                string = I18n.tr((String)object2, this.key, this.value, ((OsmPrimitive)object).getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else {
            string = this.value == null ? I18n.tr("Remove \"{0}\" for {1} {2}", this.key, this.objects.size(), I18n.trn("object", "objects", this.objects.size())) : I18n.tr("Set {0}={1} for {2} {3}", this.key, this.value, this.objects.size(), I18n.trn("object", "objects", this.objects.size()));
        }
        object = new DefaultMutableTreeNode(new JLabel(string, ImageProvider.get("data", "key"), 0));
        if (this.objects.size() == 1) {
            return object;
        }
        for (OsmPrimitive osmPrimitive : this.objects) {
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0)));
        }
        return object;
    }
}

