/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    private Map<OsmPrimitive, OsmPrimitive> cloneMap = new HashMap<OsmPrimitive, OsmPrimitive>();
    private OsmDataLayer layer;

    public Command() {
        this.layer = Main.map.mapView.getEditLayer();
    }

    public Command(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public boolean executeCommand() {
        CloneVisitor cloneVisitor = new CloneVisitor();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        this.fillModifiedData(hashSet, hashSet, hashSet);
        for (OsmPrimitive osmPrimitive : hashSet) {
            osmPrimitive.visit(cloneVisitor);
        }
        this.cloneMap = cloneVisitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, OsmPrimitive> entry : this.cloneMap.entrySet()) {
            entry.getKey().cloneFrom(entry.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == layer;
    }

    public OsmPrimitive getOrig(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.cloneMap.get(osmPrimitive);
        if (osmPrimitive2 != null) {
            return osmPrimitive2;
        }
        Main.debug("unable to find osm with id: " + osmPrimitive.getId() + " hashCode: " + osmPrimitive.hashCode());
        for (OsmPrimitive osmPrimitive3 : this.cloneMap.keySet()) {
            OsmPrimitive osmPrimitive4 = this.cloneMap.get(osmPrimitive3);
            Main.debug("now: " + osmPrimitive3.getId() + " hashCode: " + osmPrimitive3.hashCode());
            Main.debug("orig: " + osmPrimitive4.getId() + " hashCode: " + osmPrimitive4.hashCode());
        }
        return osmPrimitive2;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    public abstract MutableTreeNode description();

    private static final class CloneVisitor
    extends AbstractVisitor {
        public Map<OsmPrimitive, OsmPrimitive> orig = new HashMap<OsmPrimitive, OsmPrimitive>();

        private CloneVisitor() {
        }

        public void visit(Node node) {
            this.orig.put(node, new Node(node));
        }

        public void visit(Way way) {
            this.orig.put(way, new Way(way));
        }

        public void visit(Relation relation) {
            this.orig.put(relation, new Relation(relation));
        }
    }
}

