/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;

    public DeleteCommand(Collection<? extends OsmPrimitive> collection) {
        this.toDelete = collection;
    }

    public DeleteCommand(OsmPrimitive osmPrimitive) {
        this.toDelete = Collections.singleton(osmPrimitive);
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive) {
        super(osmDataLayer);
        this.toDelete = Collections.singleton(osmPrimitive);
    }

    public DeleteCommand(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        super(osmDataLayer);
        this.toDelete = collection;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection2.addAll(this.toDelete);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableTreeNode description() {
        void var3_8;
        Object object;
        if (this.toDelete.size() == 1) {
            OsmPrimitive osmPrimitive = this.toDelete.iterator().next();
            String string = "";
            switch (OsmPrimitiveType.from(osmPrimitive)) {
                case NODE: {
                    string = "Delete node {0}";
                    break;
                }
                case WAY: {
                    string = "Delete way {0}";
                    break;
                }
                case RELATION: {
                    string = "Delete relation {0}";
                }
            }
            return new DefaultMutableTreeNode(new JLabel(I18n.tr(string, osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0));
        }
        HashSet<OsmPrimitiveType> hashSet = new HashSet<OsmPrimitiveType>();
        for (OsmPrimitive object22 : this.toDelete) {
            hashSet.add(OsmPrimitiveType.from(object22));
        }
        Object object3 = "";
        String string = "object";
        if (hashSet.size() > 1) {
            object3 = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            object = (OsmPrimitiveType)((Object)hashSet.iterator().next());
            String string2 = ((OsmPrimitiveType)((Object)object)).getAPIName();
            switch (1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[((Enum)object).ordinal()]) {
                case 1: {
                    object3 = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case 2: {
                    object3 = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case 3: {
                    object3 = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                }
            }
        }
        object = new DefaultMutableTreeNode(new JLabel((String)object3, ImageProvider.get("data", (String)var3_8), 0));
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0)));
        }
        return object;
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) {
        CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(osmDataLayer.data);
        collectBackReferencesVisitor.initialize();
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.visit(collectBackReferencesVisitor);
        }
        collectBackReferencesVisitor.getData().addAll(collection);
        if (collectBackReferencesVisitor.getData().isEmpty()) {
            return null;
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(osmDataLayer, collectBackReferencesVisitor.getData()) && !bl) {
            return null;
        }
        return new DeleteCommand(osmDataLayer, collectBackReferencesVisitor.getData());
    }

    public static Command deleteWithReferences(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.deleteWithReferences(osmDataLayer, collection, false);
    }

    private static int testRelation(Relation relation, OsmPrimitive osmPrimitive, boolean bl) {
        if (bl) {
            return 1;
        }
        String string = new String();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember() != osmPrimitive) continue;
            string = relationMember.getRole();
            break;
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicting relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
        if (string.length() > 0) {
            extendedDialog.setContent(I18n.tr("<html>Selection \"{0}\" is used by relation \"{1}\" with role {2}.<br>Delete from relation?</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), relation.getDisplayName(DefaultNameFormatter.getInstance()), string));
            extendedDialog.showDialog();
            return extendedDialog.getValue();
        }
        extendedDialog.setContent(I18n.tr("<html>Selection \"{0}\" is used by relation \"{1}\".<br>Delete from relation?</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), relation.getDisplayName(DefaultNameFormatter.getInstance())));
        extendedDialog.showDialog();
        return extendedDialog.getValue();
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.delete(osmDataLayer, collection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(osmDataLayer.data, false);
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            for (Node node : ((Way)osmPrimitive).getNodes()) {
                if (node.isTagged()) continue;
                collectBackReferencesVisitor.initialize();
                node.visit(collectBackReferencesVisitor);
                Collection<OsmPrimitive> collection2 = collectBackReferencesVisitor.getData();
                collection2.removeAll(collection);
                int n = 0;
                for (OsmPrimitive osmPrimitive2 : collection2) {
                    if (osmPrimitive2.isDeleted()) continue;
                    ++n;
                }
                if (n != 0) continue;
                hashSet.add(node);
            }
        }
        return hashSet;
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl) {
        return DeleteCommand.delete(osmDataLayer, collection, bl, false);
    }

    public static Command delete(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection, boolean bl, boolean bl2) {
        Serializable serializable;
        OsmPrimitive osmPrimitive;
        Collection<OsmPrimitive> collection2;
        OsmPrimitive osmPrimitive22;
        Object object;
        if (collection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        HashSet<Way> hashSet2 = new HashSet<Way>();
        HashMap hashMap = new HashMap();
        if (bl) {
            object = DeleteCommand.computeNodesToDelete(osmDataLayer, hashSet);
            hashSet.addAll((Collection<OsmPrimitive>)object);
        }
        if (!bl2 && !DeleteCommand.checkAndConfirmOutlyingDeletes(osmDataLayer, hashSet)) {
            return null;
        }
        object = new CollectBackReferencesVisitor(osmDataLayer.data, false);
        for (OsmPrimitive iterator : hashSet) {
            ((CollectBackReferencesVisitor)object).initialize();
            iterator.visit((Visitor)object);
            for (OsmPrimitive osmPrimitive22 : ((CollectBackReferencesVisitor)object).getData()) {
                if (hashSet.contains(osmPrimitive22)) continue;
                if (osmPrimitive22 instanceof Way) {
                    hashSet2.add((Way)osmPrimitive22);
                    continue;
                }
                if (osmPrimitive22 instanceof Relation) {
                    if (DeleteCommand.testRelation((Relation)osmPrimitive22, iterator, bl2) == 1) {
                        collection2 = (Collection)hashMap.get(osmPrimitive22);
                        if (collection2 == null) {
                            collection2 = new HashSet<OsmPrimitive>();
                        }
                        collection2.add(iterator);
                        hashMap.put(osmPrimitive22, collection2);
                        continue;
                    }
                    return null;
                }
                return null;
            }
        }
        LinkedList linkedList = new LinkedList();
        for (Way way : hashSet2) {
            osmPrimitive22 = new Way(way);
            ((Way)osmPrimitive22).removeNodes(hashSet);
            if (((Way)osmPrimitive22).getNodesCount() < 2) {
                hashSet.add(way);
                ((CollectBackReferencesVisitor)object).initialize();
                way.visit((Visitor)object);
                collection2 = ((CollectBackReferencesVisitor)object).getData().iterator();
                while (collection2.hasNext()) {
                    osmPrimitive = (OsmPrimitive)collection2.next();
                    if (hashSet.contains(osmPrimitive)) continue;
                    if (osmPrimitive instanceof Relation) {
                        serializable = false;
                        Collection<Way> collection3 = (Collection)hashMap.get(osmPrimitive);
                        if (collection3 == null) {
                            collection3 = new HashSet<Way>();
                        } else {
                            for (OsmPrimitive osmPrimitive3 : collection3) {
                                if (osmPrimitive3 != way) continue;
                                serializable = true;
                                break;
                            }
                        }
                        if (((Boolean)serializable).booleanValue()) continue;
                        if (DeleteCommand.testRelation((Relation)osmPrimitive, way, bl2) == 1) {
                            collection3.add(way);
                            hashMap.put(osmPrimitive, collection3);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                continue;
            }
            linkedList.add(new ChangeCommand(way, osmPrimitive22));
        }
        for (Relation relation : hashMap.keySet()) {
            osmPrimitive22 = new Relation(relation);
            collection2 = ((Collection)hashMap.get(relation)).iterator();
            while (collection2.hasNext()) {
                osmPrimitive = (OsmPrimitive)collection2.next();
                ((Relation)osmPrimitive22).removeMembersFor(osmPrimitive);
            }
            linkedList.add(new ChangeCommand(relation, osmPrimitive22));
        }
        for (OsmPrimitive osmPrimitive22 : hashSet) {
            if (!(osmPrimitive22 instanceof Way) || ((OsmPrimitive)((Object)(collection2 = (Way)osmPrimitive22))).getId() == 0L) continue;
            osmPrimitive = new Way((Way)((Object)collection2));
            serializable = new ArrayList();
            for (Node node : ((Way)osmPrimitive).getNodes()) {
                if (node.getId() == 0L && hashSet.contains(node)) continue;
                serializable.add((Node)node);
            }
            ((Way)osmPrimitive).setNodes((List<Node>)((Object)serializable));
            if (serializable.size() >= ((Way)((Object)collection2)).getNodesCount()) continue;
            linkedList.add(new ChangeCommand((OsmPrimitive)((Object)collection2), osmPrimitive));
        }
        if (!hashSet.isEmpty()) {
            linkedList.add(new DeleteCommand(osmDataLayer, hashSet));
        }
        return new SequenceCommand(I18n.tr("Delete"), linkedList);
    }

    public static Command deleteWaySegment(OsmDataLayer osmDataLayer, WaySegment waySegment) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList.addAll(waySegment.way.getNodes().subList(0, waySegment.lowerIndex + 1));
        arrayList2.addAll(waySegment.way.getNodes().subList(waySegment.lowerIndex + 1, waySegment.way.getNodesCount()));
        if (arrayList.size() < 2 && arrayList2.size() < 2) {
            return new DeleteCommand(osmDataLayer, Collections.singleton(waySegment.way));
        }
        Way way = new Way(waySegment.way);
        if (arrayList.size() < 2) {
            way.setNodes(arrayList2);
            return new ChangeCommand(waySegment.way, way);
        }
        if (arrayList2.size() < 2) {
            way.setNodes(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        way.setNodes(arrayList);
        linkedList.add(new ChangeCommand(waySegment.way, way));
        Way way2 = new Way();
        way2.setKeys(way.getKeys());
        way2.setNodes(arrayList2);
        linkedList.add(new AddCommand(way2));
        return new SequenceCommand(I18n.tr("Split way segment"), linkedList);
    }

    private static boolean checkAndConfirmOutlyingDeletes(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        Area area = osmDataLayer.data.getDataSourceArea();
        if (area != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                Node node;
                if (!(osmPrimitive instanceof Node) || osmPrimitive.getId() == 0L || area.contains((node = (Node)osmPrimitive).getCoor())) continue;
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add(new JLabel("<html>" + I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you don't see) might use them.<br>Do you really want to delete?") + "</html>"));
                return ConditionalOptionPaneUtil.showConfirmationDialog("delete_outside_nodes", Main.parent, jPanel, I18n.tr("Delete confirmation"), 0, 3, 0);
            }
        }
        return true;
    }
}

