/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeletePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(UndeletePrimitivesCommand.class.getName());
    private ArrayList<OsmPrimitive> toUndelete = new ArrayList();

    protected UndeletePrimitivesCommand() {
    }

    public UndeletePrimitivesCommand(OsmPrimitive osmPrimitive) {
        this();
        this.toUndelete.add(osmPrimitive);
    }

    public UndeletePrimitivesCommand(OsmPrimitive ... osmPrimitiveArray) {
        this();
        for (int i = 0; i < osmPrimitiveArray.length; ++i) {
            this.toUndelete.add(osmPrimitiveArray[i]);
        }
    }

    public UndeletePrimitivesCommand(Collection<OsmPrimitive> collection) {
        this();
        this.toUndelete.addAll(collection);
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Undelete {0} primitives", this.toUndelete.size()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (OsmPrimitive osmPrimitive : this.toUndelete) {
            if (this.getLayer().getConflicts().hasConflictForMy(osmPrimitive)) {
                this.rememberConflict(this.getLayer().getConflicts().getConflictForMy(osmPrimitive));
                this.getLayer().getConflicts().remove(osmPrimitive);
            }
            osmPrimitive.clearOsmId();
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.toUndelete);
    }
}

