/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayPoint
extends WithAttributes
implements Comparable<WayPoint> {
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private CachedLatLon coor;

    public final LatLon getCoor() {
        return this.coor;
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public WayPoint(LatLon latLon) {
        this.coor = new CachedLatLon(latLon);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.attr.get("name") + ", " : "") + this.coor.toString() + ", " + this.attr + ")";
    }

    public void setTime() {
        double d;
        if (this.attr.containsKey("time") && (d = (double)DateUtils.fromString(this.attr.get("time").toString()).getTime()) != 0.0) {
            this.time = d / 1000.0;
        }
    }

    @Override
    public int compareTo(WayPoint wayPoint) {
        return Double.compare(this.time, wayPoint.time);
    }
}

