/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackreferencedDataSet {
    private DataSet source;
    private Map<OsmPrimitive, Set<OsmPrimitive>> referers;
    private boolean built = false;

    public BackreferencedDataSet(DataSet dataSet) {
        if (dataSet == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null."));
        }
        this.source = dataSet;
        int n = dataSet.ways.size() + dataSet.relations.size();
        this.referers = new HashMap<OsmPrimitive, Set<OsmPrimitive>>(n, 0.75f);
    }

    protected void remember(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        Set<OsmPrimitive> set = this.referers.get(osmPrimitive2);
        if (set != null) {
            set.add(osmPrimitive);
            return;
        }
        set = new HashSet<OsmPrimitive>();
        set.add(osmPrimitive);
        this.referers.put(osmPrimitive2, set);
    }

    public void build() {
        for (Way osmPrimitive : this.source.ways) {
            for (Node node : osmPrimitive.getNodes()) {
                this.remember(osmPrimitive, node);
            }
        }
        for (Relation relation : this.source.relations) {
            for (RelationMember relationMember : relation.getMembers()) {
                this.remember(relation, relationMember.getMember());
            }
        }
        this.built = true;
    }

    public Set<OsmPrimitive> getParents(OsmPrimitive osmPrimitive) {
        HashSet hashSet = this.referers.get(osmPrimitive);
        return hashSet == null ? new HashSet() : hashSet;
    }

    public Set<OsmPrimitive> getParents(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return Collections.emptySet();
        }
        collection.remove(null);
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (this.referers.get(osmPrimitive) == null) continue;
            hashSet.addAll((Collection<OsmPrimitive>)this.referers.get(osmPrimitive));
        }
        return hashSet;
    }

    public boolean hasParents(OsmPrimitive osmPrimitive) {
        return !this.getParents(osmPrimitive).isEmpty();
    }

    public DataSet getSource() {
        return this.source;
    }

    public Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive osmPrimitive) {
        Set<Relation> set = OsmPrimitive.getFilteredSet(this.getParents(osmPrimitive), Relation.class);
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (Relation relation : set) {
            for (int i = 0; i < relation.getMembersCount(); ++i) {
                if (!relation.getMember(i).refersTo(osmPrimitive)) continue;
                hashSet.add(new RelationToChildReference(relation, i, relation.getMember(i)));
            }
        }
        return hashSet;
    }

    public Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> collection) {
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(this.getRelationToChildReferences(osmPrimitive));
        }
        return hashSet;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public static class RelationToChildReference {
        private Relation parent;
        private int position;
        private String role;
        private OsmPrimitive child;

        public RelationToChildReference(Relation relation, int n, String string, OsmPrimitive osmPrimitive) {
            this.parent = relation;
            this.position = n;
            this.role = string;
            this.child = osmPrimitive;
        }

        public RelationToChildReference(Relation relation, int n, RelationMember relationMember) {
            this.parent = relation;
            this.position = n;
            this.role = relationMember.getRole();
            this.child = relationMember.getMember();
        }

        public Relation getParent() {
            return this.parent;
        }

        public int getPosition() {
            return this.position;
        }

        public String getRole() {
            return this.role;
        }

        public OsmPrimitive getChild() {
            return this.child;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.child == null ? 0 : this.child.hashCode());
            n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
            n = 31 * n + this.position;
            n = 31 * n + (this.role == null ? 0 : this.role.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RelationToChildReference relationToChildReference = (RelationToChildReference)object;
            if (this.child == null ? relationToChildReference.child != null : !this.child.equals(relationToChildReference.child)) {
                return false;
            }
            if (this.parent == null ? relationToChildReference.parent != null : !this.parent.equals(relationToChildReference.parent)) {
                return false;
            }
            if (this.position != relationToChildReference.position) {
                return false;
            }
            return !(this.role == null ? relationToChildReference.role != null : !this.role.equals(relationToChildReference.role));
        }
    }
}

