/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Changeset
implements Tagged {
    private long id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private Map<String, String> tags;
    private boolean incomplete;

    public Changeset() {
        this.id = 0L;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(long l) {
        this.id = l;
        this.incomplete = l > 0L;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset changeset) {
        if (changeset == null) {
            this.id = 0L;
            this.tags = new HashMap<String, String>();
        } else if (changeset.isIncomplete()) {
            this.setId(changeset.getId());
            this.incomplete = true;
        } else {
            this.cloneFrom(changeset);
            this.incomplete = false;
        }
    }

    public void cloneFrom(Changeset changeset) {
        this.setId(changeset.getId());
        this.setUser(changeset.getUser());
        this.setCreatedAt(changeset.getCreatedAt());
        this.setClosedAt(changeset.getClosedAt());
        this.setMin(changeset.getMin());
        this.setMax(changeset.getMax());
        this.setKeys(changeset.getKeys());
        this.setOpen(changeset.isOpen());
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public int compareTo(Changeset changeset) {
        return Long.valueOf(this.getId()).compareTo(changeset.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getLocalName() {
        return I18n.tr("Changeset {0}", this.getId());
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date date) {
        this.createdAt = date;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date date) {
        this.closedAt = date;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon latLon) {
        this.min = latLon;
    }

    public LatLon getMax() {
        return this.max;
    }

    public void setMax(LatLon latLon) {
        this.max = latLon;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> map) {
        this.tags = map;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean bl) {
        this.incomplete = bl;
    }

    @Override
    public void put(String string, String string2) {
        this.tags.put(string, string2);
    }

    @Override
    public String get(String string) {
        return this.tags.get(string);
    }

    @Override
    public void remove(String string) {
        this.tags.remove(string);
    }

    public boolean hasEqualSemanticAttributes(Changeset changeset) {
        if (changeset == null) {
            return false;
        }
        if (this.closedAt == null ? changeset.closedAt != null : !this.closedAt.equals(changeset.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? changeset.createdAt != null : !this.createdAt.equals(changeset.createdAt)) {
            return false;
        }
        if (this.id != changeset.id) {
            return false;
        }
        if (this.max == null ? changeset.max != null : !this.max.equals(changeset.max)) {
            return false;
        }
        if (this.min == null ? changeset.min != null : !this.min.equals(changeset.min)) {
            return false;
        }
        if (this.open != changeset.open) {
            return false;
        }
        if (this.tags == null ? changeset.tags != null : !((Object)this.tags).equals(changeset.tags)) {
            return false;
        }
        return !(this.user == null ? changeset.user != null : !this.user.equals(changeset.user));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        if (this.id > 0L) {
            return 31 * n + this.getClass().hashCode();
        }
        n = 31 * n + (this.closedAt == null ? 0 : this.closedAt.hashCode());
        n = 31 * n + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        n = 31 * n + (this.max == null ? 0 : this.max.hashCode());
        n = 31 * n + (this.min == null ? 0 : this.min.hashCode());
        n = 31 * n + (this.open ? 1231 : 1237);
        n = 31 * n + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        n = 31 * n + (this.user == null ? 0 : this.user.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)object;
        if (this.id > 0L && changeset.id == this.id) {
            return true;
        }
        if (this.closedAt == null ? changeset.closedAt != null : !this.closedAt.equals(changeset.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? changeset.createdAt != null : !this.createdAt.equals(changeset.createdAt)) {
            return false;
        }
        if (this.id != changeset.id) {
            return false;
        }
        if (this.max == null ? changeset.max != null : !this.max.equals(changeset.max)) {
            return false;
        }
        if (this.min == null ? changeset.min != null : !this.min.equals(changeset.min)) {
            return false;
        }
        if (this.open != changeset.open) {
            return false;
        }
        if (this.tags == null ? changeset.tags != null : !((Object)this.tags).equals(changeset.tags)) {
            return false;
        }
        return !(this.user == null ? changeset.user != null : !this.user.equals(changeset.user));
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }
}

