/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static long uidCounter = 0L;
    private static HashMap<Long, User> userMap = new HashMap();
    private String name;
    private long uid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextLocalUid() {
        Class<User> clazz = User.class;
        synchronized (User.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return --uidCounter;
        }
    }

    public static User createLocalUser(String string) {
        User user = new User(User.getNextLocalUid(), string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long l, String string) {
        User user = new User(l, string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User getById(long l) {
        return userMap.get(l);
    }

    public static List<User> getByName(String string) {
        string = string == null ? "" : string;
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.getName().equals(string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public long getId() {
        return this.uid;
    }

    private User(long l, String string) {
        this.uid = l;
        this.name = string;
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        User user = (User)object;
        if (this.name == null ? user.name != null : !this.name.equals(user.name)) {
            return false;
        }
        return this.uid == user.uid;
    }
}

