/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive {
    private Node[] nodes = new Node[0];
    public boolean isMappaintArea = false;
    public Integer mappaintDrawnAreaCode = 0;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    public void setNodes(List<Node> list) {
        this.nodes = list == null ? new Node[0] : list.toArray(new Node[list.size()]);
        this.clearCached();
    }

    public int getNodesCount() {
        return this.nodes.length;
    }

    public Node getNode(int n) {
        return this.nodes[n];
    }

    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearCached() {
        super.clearCached();
        this.isMappaintArea = false;
        this.mappaintDrawnAreaCode = 0;
    }

    public ArrayList<Pair<Node, Node>> getNodePairs(boolean bl) {
        ArrayList<Pair<Node, Node>> arrayList = new ArrayList<Pair<Node, Node>>();
        if (this.incomplete) {
            return arrayList;
        }
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            Pair<Node, Node> pair = new Pair<Node, Node>(node, node2);
            if (bl) {
                Pair.sort(pair);
            }
            arrayList.add(pair);
            node = node2;
        }
        return arrayList;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public Way() {
        super(0L);
    }

    public Way(Way way) {
        super(way.getId());
        this.cloneFrom(way);
    }

    public Way(long l) throws IllegalArgumentException {
        super(l);
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        Way way = (Way)osmPrimitive;
        this.nodes = new Node[way.nodes.length];
        System.arraycopy(way.nodes, 0, this.nodes, 0, way.nodes.length);
    }

    public String toString() {
        if (this.incomplete) {
            return "{Way id=" + this.getId() + " version=" + this.getVersion() + " (incomplete)}";
        }
        return "{Way id=" + this.getId() + " version=" + this.getVersion() + " nodes=" + Arrays.toString(this.nodes) + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Way way = (Way)osmPrimitive;
        return Arrays.equals(this.nodes, way.nodes);
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation) {
            return 1;
        }
        return osmPrimitive instanceof Way ? Long.valueOf(this.getId()).compareTo(osmPrimitive.getId()) : -1;
    }

    public void removeNode(Node node) {
        int n;
        if (this.incomplete) {
            return;
        }
        boolean bl = this.lastNode() == node && this.firstNode() == node;
        List<Node> list = this.getNodes();
        while ((n = list.indexOf(node)) >= 0) {
            list.remove(n);
        }
        n = list.size();
        if (bl && n > 2) {
            this.addNode(this.firstNode());
        } else if (n >= 2 && n <= 3 && list.get(0) == list.get(n - 1)) {
            list.remove(n - 1);
        }
        this.setNodes(list);
    }

    public void removeNodes(Collection<? extends OsmPrimitive> collection) {
        if (this.incomplete) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.removeNode((Node)osmPrimitive);
        }
    }

    public void addNode(Node node) throws IllegalStateException {
        if (node == null) {
            return;
        }
        if (this.incomplete) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
        }
        this.clearCached();
        Node[] nodeArray = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, nodeArray, 0, this.nodes.length);
        nodeArray[this.nodes.length] = node;
        this.nodes = nodeArray;
    }

    public void addNode(int n, Node node) throws IllegalStateException, IndexOutOfBoundsException {
        if (node == null) {
            return;
        }
        if (this.incomplete) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
        }
        this.clearCached();
        Node[] nodeArray = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, nodeArray, 0, n);
        System.arraycopy(this.nodes, n, nodeArray, n + 1, this.nodes.length - n);
        nodeArray[n] = node;
        this.nodes = nodeArray;
    }

    public boolean isClosed() {
        if (this.incomplete) {
            return false;
        }
        return this.nodes.length >= 3 && this.lastNode() == this.firstNode();
    }

    public Node lastNode() {
        if (this.incomplete || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[this.nodes.length - 1];
    }

    public Node firstNode() {
        if (this.incomplete || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0];
    }

    public boolean isFirstLastNode(Node node) {
        if (this.incomplete || this.nodes.length == 0) {
            return false;
        }
        return node == this.firstNode() || node == this.lastNode();
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }
}

