/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;

    private ConditionalOptionPaneUtil() {
    }

    public static boolean getDialogShowingEnabled(String string) {
        return Main.pref.getBoolean("message." + string, true);
    }

    public static void setDialogShowingEnabled(String string, boolean bl) {
        Main.pref.put("message." + string, bl);
    }

    public static int showOptionDialog(String string, Component component, Object object, String string2, int n, int n2, Object[] objectArray, Object object2) throws HeadlessException {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(string)) {
            return Integer.MIN_VALUE;
        }
        MessagePanel messagePanel = new MessagePanel(string, object);
        int n3 = JOptionPane.showOptionDialog(component, messagePanel, string2, n, n2, null, objectArray, object2);
        messagePanel.remeberDialogShowingEnabled();
        return n3;
    }

    public static boolean showConfirmationDialog(String string, Component component, Object object, String string2, int n, int n2, int n3) throws HeadlessException {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(string)) {
            return true;
        }
        MessagePanel messagePanel = new MessagePanel(string, object);
        int n4 = JOptionPane.showConfirmDialog(component, messagePanel, string2, n, n2);
        messagePanel.remeberDialogShowingEnabled();
        return n4 == n3;
    }

    public static void showMessageDialog(String string, Component component, Object object, String string2, int n) {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(string)) {
            return;
        }
        MessagePanel messagePanel = new MessagePanel(string, object);
        JOptionPane.showMessageDialog(component, messagePanel, string2, n);
        messagePanel.remeberDialogShowingEnabled();
    }

    private static class MessagePanel
    extends JPanel {
        JCheckBox cbShowDialog;
        String preferenceKey;

        public MessagePanel(String string, Object object) {
            this.preferenceKey = string;
            this.cbShowDialog = new JCheckBox(I18n.tr("Do not show again"));
            this.cbShowDialog.setSelected(!ConditionalOptionPaneUtil.getDialogShowingEnabled(string));
            this.setLayout(new GridBagLayout());
            if (object instanceof Component) {
                this.add((Component)object, GBC.eop());
            } else {
                this.add((Component)new JLabel(object.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowDialog, GBC.eol());
        }

        public boolean getDialogShowingEnabled() {
            return this.cbShowDialog.isSelected();
        }

        public void remeberDialogShowingEnabled() {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(this.preferenceKey, !this.getDialogShowingEnabled());
        }
    }
}

