/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog {
    private int result = 0;
    public static final int DialogNotShown = -99;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable = false;
    private String rememberSizePref = "";
    private WindowGeometry defaultWindowGeometry = null;
    private String togglePref = "";
    private String toggleCheckboxText = I18n.tr("Do not show again");
    private JCheckBox toggleCheckbox = null;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bIcons;
    private boolean placeContentInScrollPane;
    protected Object contentConstraints = GBC.eol().anchor(10).fill(1).insets(5, 10, 5, 0);
    protected ArrayList<JButton> buttons = new ArrayList();

    public ExtendedDialog(Component component, String string, String[] stringArray) {
        super(JOptionPane.getFrameForComponent(component), string, true);
        this.parent = component;
        this.bTexts = stringArray;
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl) {
        super(JOptionPane.getFrameForComponent(component), string, bl);
        this.parent = component;
        this.bTexts = stringArray;
    }

    public void setButtonIcons(String[] stringArray) {
        this.bIcons = stringArray;
    }

    public void setContent(Component component) {
        this.setContent(component, true);
    }

    public void setContent(Component component, boolean bl) {
        this.content = component;
        this.placeContentInScrollPane = bl;
    }

    public void setContent(String string) {
        this.setContent(ExtendedDialog.string2label(string), false);
    }

    public void showDialog() {
        if (this.toggleCheckState(this.togglePref)) {
            this.result = -99;
            return;
        }
        this.setupDialog();
        this.setVisible(true);
        this.toggleSaveState();
    }

    public int getValue() {
        return this.result;
    }

    @Deprecated
    protected void setupDialog(Component component, String[] stringArray) {
        this.setContent(component);
        this.setButtonIcons(stringArray);
        this.setupDialog();
    }

    protected void setupDialog() {
        boolean bl;
        this.setupEscListener();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            AbstractAction abstractAction = new AbstractAction(this.bTexts[i]){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExtendedDialog.this.buttonAction(actionEvent);
                }
            };
            JButton jButton = new JButton(abstractAction);
            if (this.bIcons != null && this.bIcons[i] != null) {
                jButton.setIcon(ImageProvider.get(this.bIcons[i]));
            }
            if (i == 0) {
                this.rootPane.setDefaultButton(jButton);
            }
            jPanel.add((Component)jButton, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(jButton);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add(this.content, this.contentConstraints);
        if (this.toggleable) {
            this.toggleCheckbox = new JCheckBox(this.toggleCheckboxText);
            boolean bl2 = Main.pref.getBoolean("message." + this.togglePref, true);
            this.toggleCheckbox.setSelected(!bl2);
            jPanel2.add((Component)this.toggleCheckbox, GBC.eol().anchor(21).insets(5, 5, 5, 5));
        }
        jPanel2.add((Component)jPanel, GBC.eol().anchor(10).insets(5, 5, 5, 5));
        if (this.placeContentInScrollPane) {
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(null);
            this.setContentPane(jScrollPane);
        } else {
            this.setContentPane(jPanel2);
        }
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.findMaxDialogSize();
        boolean bl3 = dimension.width > dimension2.width;
        boolean bl4 = bl = dimension.height > dimension2.height;
        if (dimension2.width > 0 && dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > 0 && dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        if (!bl3 && bl) {
            dimension.width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize(dimension);
        this.setLocationRelativeTo(this.parent);
    }

    protected void buttonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.bTexts.length; ++i) {
            if (!this.bTexts[i].equals(string)) continue;
            this.result = i + 1;
            break;
        }
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(Math.round(dimension.width * 2 / 3), Math.round(dimension.height * 2 / 3));
        try {
            if (this.parent != null) {
                dimension2 = JOptionPane.getFrameForComponent(this.parent).getSize();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dimension2;
    }

    private void setupEscListener() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                ExtendedDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.repaint();
        }
        if (this.rememberSizePref.length() != 0 && this.defaultWindowGeometry != null) {
            if (bl) {
                new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry).apply(this);
            } else {
                new WindowGeometry(this).remember(this.rememberSizePref);
            }
        }
        super.setVisible(bl);
    }

    public void setRememberWindowGeometry(String string, WindowGeometry windowGeometry) {
        this.rememberSizePref = string == null ? "" : string;
        this.defaultWindowGeometry = windowGeometry;
    }

    public void toggleEnable(String string) {
        this.toggleable = true;
        this.togglePref = string;
    }

    public void toggleDisable() {
        this.toggleable = false;
    }

    public void setToggleCheckboxText(String string) {
        this.toggleCheckboxText = string;
    }

    private boolean toggleCheckState(String string) {
        boolean bl = this.toggleable = string != null && !string.equals("");
        if (!this.toggleable) {
            return false;
        }
        this.togglePref = string;
        return !Main.pref.getBoolean("message." + string, true);
    }

    private void toggleSaveState() {
        if (!this.toggleable || this.toggleCheckbox == null) {
            return;
        }
        Main.pref.put("message." + this.togglePref, !this.toggleCheckbox.isSelected());
    }

    private static JMultilineLabel string2label(String string) {
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jMultilineLabel.setMaxWidth(Math.round(dimension.width * 1 / 2));
        return jMultilineLabel;
    }
}

