/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame, SplashScreen splashScreen) {
        super(splashScreen);
        jFrame.setContentPane(contentPane);
        jFrame.setJMenuBar(this.menu);
        jFrame.setBounds(bounds);
        jFrame.setIconImage(ImageProvider.get("logo.png").getImage());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!Main.saveUnsavedModifications()) {
                    return;
                }
                Main.saveGuiGeometry();
                System.exit(0);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void main(String[] stringArray) {
        I18n.init();
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        List<String> list = Arrays.asList(stringArray);
        final HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (String string : stringArray) {
            int n;
            if (!string.startsWith("--")) {
                string = "--download=" + string;
            }
            String string2 = (n = string.indexOf(61)) == -1 ? string.substring(2) : string.substring(2, n);
            String string3 = n == -1 ? "" : string.substring(n + 1);
            LinkedList<String> linkedList = (LinkedList<String>)hashMap.get(string2);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            linkedList.add(string3);
            hashMap.put(string2, linkedList);
        }
        Main.pref.init(hashMap.containsKey("reset-preferences"));
        if (hashMap.containsKey("language")) {
            I18n.set((String)((Collection)hashMap.get("language")).toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        if (list.contains("--help") || list.contains("-?") || list.contains("-h")) {
            System.out.println(I18n.tr("Java OpenStreetMap Editor") + "\n\n" + I18n.tr("usage") + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options") + ":\n" + "\t--help|-?|-h                              " + I18n.tr("Show this help") + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument") + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box") + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)") + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open file (as raw gps, if .gpx)") + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps") + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search") + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode") + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default") + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language.") + "\n\n" + I18n.tr("options provided as Java system properties") + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ") + I18n.tr("Change the folder for all user settings") + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to increase the maximum size of allocated memory") + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples") + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters are read in the order they are specified, so make sure you load\nsome data before --selection") + "\n\n" + I18n.tr("Instead of --download=<bbox> you may specify osm://<bbox>\n"));
            System.exit(0);
        }
        SplashScreen splashScreen = new SplashScreen(Main.pref.getBoolean("draw.splashscreen", true));
        splashScreen.setStatus(I18n.tr("Activating updated plugins"));
        PluginHandler.earlyCleanup();
        splashScreen.setStatus(I18n.tr("Loading early plugins"));
        PluginHandler.loadPlugins(true);
        splashScreen.setStatus(I18n.tr("Setting defaults"));
        MainApplication.preConstructorInit(hashMap);
        MainApplication.removeObsoletePreferences();
        splashScreen.setStatus(I18n.tr("Creating main GUI"));
        JFrame jFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor"));
        Main.parent = jFrame;
        final MainApplication mainApplication = new MainApplication(jFrame, splashScreen);
        splashScreen.setStatus(I18n.tr("Loading plugins"));
        PluginHandler.loadPlugins(false);
        toolbar.refreshToolbarControl();
        jFrame.setVisible(true);
        splashScreen.closeSplash();
        if ((!hashMap.containsKey("no-maximize") && !hashMap.containsKey("geometry") && Main.pref.get("gui.geometry").length() == 0 || hashMap.containsKey("maximize")) && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jFrame.setExtendedState(6);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                mainApplication.postConstructorProcessCmdLine(hashMap);
            }
        });
    }

    public static void removeObsoletePreferences() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"sample.preference.that.does.not.exist", "osm-server.version", "osm-server.additional-versions", null}) {
            if (string == null || !Main.pref.hasKey(string)) continue;
            Main.pref.removeFromCollection(string, Main.pref.get(string));
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }
}

