/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    private static final Logger logger = Logger.getLogger(RelationMemberListMergeModel.class.getName());

    @Override
    public boolean isEqualEntry(RelationMember relationMember, RelationMember relationMember2) {
        boolean bl = relationMember.getRole().equals(relationMember2.getRole());
        bl = relationMember.getMember().getId() > 0L ? bl && relationMember.getMember().getId() == relationMember2.getMember().getId() : bl && relationMember == relationMember2;
        return bl;
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel3 = relationMemberListMergeModel2;
                relationMemberListMergeModel3.getClass();
                super(relationMemberListMergeModel3, listRole);
            }

            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
        if (defaultTableModel == this.getMergedTableModel() && n2 == 1) {
            RelationMember relationMember = (RelationMember)this.getMergedEntries().get(n);
            RelationMember relationMember2 = new RelationMember((String)object, relationMember.getMember());
            this.getMergedEntries().remove(n);
            this.getMergedEntries().add(n, relationMember2);
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation relation, Relation relation2) {
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "my"));
        }
        if (relation2 == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "their"));
        }
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (RelationMember relationMember : relation.getMembers()) {
            this.getMyEntries().add(relationMember);
        }
        for (RelationMember relationMember : relation2.getMembers()) {
            this.getTheirEntries().add(relationMember);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember relationMember : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(relationMember));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember relationMember) {
        return new RelationMember(relationMember);
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation relation, Relation relation2) {
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "my"));
        }
        if (relation2 == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "their"));
        }
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Can't build resolution command"));
        }
        return new RelationMemberConflictResolverCommand(relation, relation2, this.getMergedEntries());
    }
}

