/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberConflictDecision {
    private Relation relation;
    private int pos;
    private OsmPrimitive originalPrimitive;
    private String role;
    private RelationMemberConflictDecisionType decision;

    public RelationMemberConflictDecision(Relation relation, int n) throws IllegalArgumentException {
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "relation"));
        }
        RelationMember relationMember = relation.getMember(n);
        if (relationMember == null) {
            throw new IndexOutOfBoundsException(I18n.tr("Position {0} is out of range. Current number of members is {1}.", n, relation.getMembersCount()));
        }
        this.relation = relation;
        this.pos = n;
        this.originalPrimitive = relationMember.getMember();
        this.role = relationMember.hasRole() ? relationMember.getRole() : "";
        this.decision = RelationMemberConflictDecisionType.UNDECIDED;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public int getPos() {
        return this.pos;
    }

    public OsmPrimitive getOriginalPrimitive() {
        return this.originalPrimitive;
    }

    public String getRole() {
        return this.role;
    }

    public RelationMemberConflictDecisionType getDecision() {
        return this.decision;
    }

    public void setRole(String string) {
        this.role = string == null ? "" : string;
    }

    public void decide(RelationMemberConflictDecisionType relationMemberConflictDecisionType) {
        if (relationMemberConflictDecisionType == null) {
            relationMemberConflictDecisionType = RelationMemberConflictDecisionType.UNDECIDED;
        }
        this.decision = relationMemberConflictDecisionType;
    }

    public boolean isDecided() {
        return !RelationMemberConflictDecisionType.UNDECIDED.equals((Object)this.decision);
    }

    public boolean matches(Relation relation, int n) {
        return this.relation == relation && this.pos == n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.decision == null ? 0 : this.decision.hashCode());
        n = 31 * n + (this.originalPrimitive == null ? 0 : this.originalPrimitive.hashCode());
        n = 31 * n + this.pos;
        n = 31 * n + (this.relation == null ? 0 : this.relation.hashCode());
        n = 31 * n + (this.role == null ? 0 : this.role.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationMemberConflictDecision relationMemberConflictDecision = (RelationMemberConflictDecision)object;
        if (this.decision == null ? relationMemberConflictDecision.decision != null : !this.decision.equals((Object)relationMemberConflictDecision.decision)) {
            return false;
        }
        if (this.originalPrimitive == null ? relationMemberConflictDecision.originalPrimitive != null : !this.originalPrimitive.equals(relationMemberConflictDecision.originalPrimitive)) {
            return false;
        }
        if (this.pos != relationMemberConflictDecision.pos) {
            return false;
        }
        if (this.relation == null ? relationMemberConflictDecision.relation != null : !this.relation.equals(relationMemberConflictDecision.relation)) {
            return false;
        }
        return !(this.role == null ? relationMemberConflictDecision.role != null : !this.role.equals(relationMemberConflictDecision.role));
    }
}

