/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationMemberConflictDecisionType {
    REPLACE,
    REMOVE,
    UNDECIDED;


    public static void prepareLabel(RelationMemberConflictDecisionType relationMemberConflictDecisionType, JLabel jLabel) {
        switch (relationMemberConflictDecisionType) {
            case REMOVE: {
                jLabel.setText(I18n.tr("Remove"));
                jLabel.setToolTipText(I18n.tr("Remove this relation member from the relation"));
                break;
            }
            case REPLACE: {
                jLabel.setText(I18n.tr("Replace"));
                jLabel.setToolTipText(I18n.tr("Replace the way this member refers to with the combined way"));
                break;
            }
            case UNDECIDED: {
                jLabel.setText(I18n.tr("Undecided"));
                jLabel.setToolTipText(I18n.tr("Not decided yet"));
            }
        }
    }

    public static void prepareComboBox(RelationMemberConflictDecisionType relationMemberConflictDecisionType, JComboBox jComboBox) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        defaultComboBoxModel.removeAllElements();
        switch (relationMemberConflictDecisionType) {
            case REMOVE: {
                defaultComboBoxModel.addElement(I18n.tr("Remove"));
                jComboBox.setToolTipText(I18n.tr("Remove this relation member from the relation"));
                jComboBox.setSelectedIndex(0);
                break;
            }
            case REPLACE: {
                defaultComboBoxModel.addElement(I18n.tr("Replace"));
                jComboBox.setToolTipText(I18n.tr("Replace the way this member refers to with the combined way"));
                jComboBox.setSelectedIndex(0);
                break;
            }
            case UNDECIDED: {
                defaultComboBoxModel.addElement(I18n.tr("Undecided"));
                jComboBox.setToolTipText(I18n.tr("Not decided yet"));
                jComboBox.setSelectedIndex(0);
            }
        }
    }
}

