/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CommandStackDialog
extends ToggleDialog
implements OsmDataLayer.CommandQueueListener {
    private DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private JTree tree = new JTree(this.treeModel);

    public CommandStackDialog(MapFrame mapFrame) {
        super(I18n.tr("Command Stack"), "commandstack", I18n.tr("Open a list of all commands (undo buffer)."), Shortcut.registerShortcut("subwindow:commandstack", I18n.tr("Toggle: {0}", I18n.tr("Command Stack")), 79, 4, 1), 100, true);
        Main.main.undoRedo.listenerCommands.add(this);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.expandRow(0);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof JLabel) {
                    JLabel jLabel = (JLabel)defaultMutableTreeNode.getUserObject();
                    this.setIcon(jLabel.getIcon());
                    this.setText(jLabel.getText());
                }
                return this;
            }
        });
        this.tree.setVisibleRowCount(8);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.buildList();
        } else if (this.tree != null) {
            this.treeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(bl);
    }

    private void buildList() {
        if (Main.main.undoRedo.commands.size() != 0) {
            this.setTitle(I18n.tr("Command Stack: {0}", Main.main.undoRedo.commands.size()));
        } else {
            this.setTitle(I18n.tr("Command Stack"));
        }
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
            return;
        }
        LinkedList<Command> linkedList = Main.main.undoRedo.commands;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Command command : linkedList) {
            defaultMutableTreeNode.add(command.description());
        }
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.tree.scrollRowToVisible(this.treeModel.getChildCount(defaultMutableTreeNode) - 1);
    }

    public void commandChanged(int n, int n2) {
        if (!this.isVisible()) {
            return;
        }
        this.treeModel.setRoot(new DefaultMutableTreeNode());
        this.buildList();
    }
}

