/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionListDialog
extends ToggleDialog
implements SelectionChangedListener,
Layer.LayerChangeListener {
    private static final int SELECTION_HISTORY_SIZE = 10;
    private final DefaultListModel list = new DefaultListModel();
    private LinkedList<Collection<? extends OsmPrimitive>> selectionHistory;
    private JList displaylist = new JList(this.list);
    private SideButton selectButton;
    private SideButton searchButton;
    private JPopupMenu popupMenu;
    private JMenuItem zoomToElement;
    private Collection<? extends OsmPrimitive> historyIgnoreSelection = null;

    public SelectionListDialog() {
        super(I18n.tr("Current Selection"), "selectionlist", I18n.tr("Open a selection list window."), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection")), 84, 4, 1), 150, true);
        this.selectionHistory = new LinkedList();
        this.popupMenu = new JPopupMenu();
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    SelectionListDialog.this.updateMap();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                SelectionListDialog.this.showPopupMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SelectionListDialog.this.showPopupMenu(mouseEvent);
            }
        });
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.selectButton = new SideButton(I18n.marktr("Select"), "select", "SelectionList", I18n.tr("Set the selected elements on the map to the selected items in the list above."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionListDialog.this.updateMap();
            }
        });
        jPanel.add(this.selectButton);
        BasicArrowButton basicArrowButton = this.createArrowButton(this.selectButton);
        basicArrowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionListDialog.this.showSelectionHistoryMenu();
            }
        });
        this.add((Component)jPanel, "South");
        this.zoomToElement = new JMenuItem(I18n.tr("Zoom to selected element(s)"));
        this.zoomToElement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionListDialog.this.zoomToSelectedElement();
            }
        });
        this.searchButton = new SideButton(I18n.marktr("Search"), "search", "SelectionList", I18n.tr("Search for objects."), Main.main.menu.search);
        jPanel.add(this.searchButton);
        BasicArrowButton basicArrowButton2 = this.createArrowButton(this.searchButton);
        basicArrowButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionListDialog.this.showSearchHistoryMenu();
            }
        });
        this.popupMenu.add(this.zoomToElement);
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Zoom to selection"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionListDialog.this.zoomToSelection();
            }
        });
        this.popupMenu.add(jMenuItem);
        if (Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
        DataSet.selListeners.add(this);
        Layer.listeners.add(this);
    }

    private BasicArrowButton createArrowButton(SideButton sideButton) {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        basicArrowButton.setBorder(BorderFactory.createEmptyBorder());
        sideButton.setLayout(new BorderLayout());
        sideButton.add((Component)basicArrowButton, "East");
        return basicArrowButton;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.zoomToElement.setVisible(this.displaylist.getSelectedIndex() >= 0);
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void zoomToSelection() {
        new AutoScaleAction("selection").actionPerformed(null);
    }

    public void zoomToSelectedElement() {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        int[] nArray = this.displaylist.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Object e = this.list.get(nArray[i]);
            if (!(e instanceof OsmPrimitive)) continue;
            ((OsmPrimitive)e).visit(boundingXYVisitor);
        }
        if (boundingXYVisitor.getBounds() == null) {
            return;
        }
        boundingXYVisitor.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
    }

    private void showSelectionHistoryMenu() {
        if (this.selectionHistory.size() == 0) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Collection collection : this.selectionHistory) {
            SelectionMenuItem selectionMenuItem = new SelectionMenuItem(collection);
            jPopupMenu.add(selectionMenuItem);
        }
        Rectangle rectangle = this.selectButton.getBounds();
        jPopupMenu.show(this.selectButton, rectangle.x, rectangle.y + rectangle.height);
    }

    private void showSearchHistoryMenu() {
        if (SearchAction.searchHistory.size() == 0) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (SearchAction.SearchSetting searchSetting : SearchAction.searchHistory) {
            SearchMenuItem searchMenuItem = new SearchMenuItem(searchSetting);
            jPopupMenu.add(searchMenuItem);
        }
        Rectangle rectangle = this.searchButton.getBounds();
        jPopupMenu.show(this.searchButton, rectangle.x, rectangle.y + rectangle.height);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.list == null || !this.isVisible()) {
            return;
        }
        OsmPrimitive[] osmPrimitiveArray = DataSet.sort(collection);
        this.list.setSize(osmPrimitiveArray.length);
        int n = 0;
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            this.list.setElementAt(osmPrimitive, n++);
        }
        if (this.selectionHistory != null && collection.size() > 0 && !((Object)collection).equals(this.historyIgnoreSelection)) {
            this.historyIgnoreSelection = null;
            try {
                Collection<? extends OsmPrimitive> collection2 = this.selectionHistory.getFirst();
                if (((Object)collection2).equals(collection)) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.selectionHistory.addFirst(collection);
            while (this.selectionHistory.size() > 10) {
                this.selectionHistory.removeLast();
            }
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Way) {
                ++n2;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ++n3;
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ++n4;
        }
        if (n3 + n2 + n4 != 0) {
            this.setTitle(I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", n4, n2, n3));
        } else {
            this.setTitle(I18n.tr("Selection"));
        }
    }

    public void updateMap() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (int i = 0; i < this.list.getSize(); ++i) {
            if (!this.displaylist.isSelectedIndex(i)) continue;
            linkedList.add((OsmPrimitive)this.list.get(i));
        }
        Main.main.getCurrentDataSet().setSelected(linkedList);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)layer2;
            this.selectionChanged(osmDataLayer.data.getSelected());
        } else {
            List list = Collections.emptyList();
            this.selectionChanged(list);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }

    protected class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting searchSetting) {
            super(searchSetting.toString());
            this.s = searchSetting;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchAction.searchWithoutHistory(this.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> collection) {
            this.sel = collection;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Way) {
                    ++n;
                    continue;
                }
                if (osmPrimitive instanceof Node) {
                    ++n2;
                    continue;
                }
                if (!(osmPrimitive instanceof Relation)) continue;
                ++n3;
            }
            Object object = "";
            if (n != 0) {
                object = (String)object + (((String)object).length() > 0 ? ", " : "") + I18n.trn("{0} way", "{0} ways", n, n);
            }
            if (n2 != 0) {
                object = (String)object + (((String)object).length() > 0 ? ", " : "") + I18n.trn("{0} node", "{0} nodes", n2, n2);
            }
            if (n3 != 0) {
                object = (String)object + (((String)object).length() > 0 ? ", " : "") + I18n.trn("{0} relation", "{0} relations", n3, n3);
            }
            this.setText(I18n.tr("Selection: {0}", object));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectionListDialog.this.historyIgnoreSelection = this.sel;
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }
}

