/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.help.HelpBuilder;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ToggleDialog
extends JPanel
implements Helpful {
    private ToggleDialogAction toggleAction;
    private String preferencePrefix;
    private DialogsPanel dialogsPanel;
    private TitleBar titleBar;
    private boolean isShowing;
    private boolean isDocked;
    private boolean isCollapsed;
    private int preferredHeight;
    private JLabel lblMinimized;
    private JDialog detachedDialog;

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n) {
        this(string, string2, string3, shortcut, n, false);
    }

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n, boolean bl) {
        super(new BorderLayout());
        this.preferencePrefix = string2;
        this.setPreferredSize(new Dimension(0, n));
        this.setMinimumSize(new Dimension(0, 0));
        this.preferredHeight = n;
        this.toggleAction = new ToggleDialogAction(string, "dialogs/" + string2, string3, shortcut, string2);
        String string4 = "Dialog/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        this.toggleAction.putValue("help", string4.substring(0, string4.length() - 6));
        this.setLayout(new BorderLayout());
        this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
        this.titleBar = new TitleBar(string, string2);
        this.add((Component)this.titleBar, "North");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.isShowing = Main.pref.getBoolean(this.preferencePrefix + ".visible", bl);
        this.isDocked = Main.pref.getBoolean(this.preferencePrefix + ".docked", true);
        this.isCollapsed = Main.pref.getBoolean(this.preferencePrefix + ".minimized", false);
    }

    public void showDialog() {
        this.setIsShowing(true);
        if (!this.isDocked) {
            this.detach();
        } else {
            this.dock();
            this.setVisible(true);
        }
        this.setIsShowing(true);
        this.toggleAction.putValue("selected", false);
        this.toggleAction.putValue("selected", true);
    }

    public void hideDialog() {
        this.closeDetachedDialog();
        this.setVisible(false);
        this.setIsShowing(false);
        this.toggleAction.putValue("selected", false);
    }

    protected void dock() {
        this.detachedDialog = null;
        this.titleBar.setVisible(true);
        this.setIsDocked(true);
    }

    protected void detach() {
        this.setContentVisible(true);
        this.setVisible(true);
        this.titleBar.setVisible(false);
        this.detachedDialog = new DetachedDialog();
        this.detachedDialog.setVisible(true);
        this.setIsDocked(false);
    }

    public void collapse() {
        this.setContentVisible(false);
        this.setIsCollapsed(true);
        this.setPreferredSize(new Dimension(0, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "minimized"));
    }

    protected void expand() {
        this.setContentVisible(true);
        this.setIsCollapsed(false);
        this.setPreferredSize(new Dimension(0, this.preferredHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "normal"));
    }

    protected void setContentVisible(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this.titleBar) continue;
            componentArray[i].setVisible(bl);
        }
    }

    public void closeDetachedDialog() {
        if (this.detachedDialog != null) {
            this.detachedDialog.setVisible(false);
            this.detachedDialog.getContentPane().removeAll();
            this.detachedDialog.dispose();
        }
    }

    protected Rectangle getDetachedGeometry(Rectangle rectangle) {
        return rectangle;
    }

    protected Dimension getDefaultDetachedSize() {
        return new Dimension(Main.map.DEF_TOGGLE_DLG_WIDTH, this.preferredHeight);
    }

    public AbstractAction getToggleAction() {
        return this.toggleAction;
    }

    public String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    public void setDialogsPanel(DialogsPanel dialogsPanel) {
        this.dialogsPanel = dialogsPanel;
    }

    public String getName() {
        return "toggleDialog." + this.preferencePrefix;
    }

    public void setTitle(String string) {
        this.titleBar.setTitle(string);
    }

    private void setIsShowing(boolean bl) {
        this.isShowing = bl;
        Main.pref.put(this.preferencePrefix + ".visible", bl);
    }

    private void setIsDocked(boolean bl) {
        this.isDocked = bl;
        Main.pref.put(this.preferencePrefix + ".docked", bl);
    }

    private void setIsCollapsed(boolean bl) {
        this.isCollapsed = bl;
        Main.pref.put(this.preferencePrefix + ".minimized", bl);
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public boolean isDialogShowing() {
        return this.isShowing;
    }

    public boolean isDialogInDefaultView() {
        return this.isShowing && this.isDocked && !this.isCollapsed;
    }

    public boolean isDialogInCollapsedView() {
        return this.isShowing && this.isDocked && this.isCollapsed;
    }

    public String helpTopic() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length() - 6);
        return "Dialog/" + string;
    }

    private class DetachedDialog
    extends JDialog {
        public DetachedDialog() {
            super(JOptionPane.getFrameForComponent(Main.parent));
            this.getContentPane().add(ToggleDialog.this);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DetachedDialog.this.rememberGeometry();
                    DetachedDialog.this.getContentPane().removeAll();
                    DetachedDialog.this.dispose();
                    ToggleDialog.this.dock();
                    ToggleDialog.this.expand();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    super.mouseEntered(mouseEvent);
                    System.out.println("requesting focus ...");
                    DetachedDialog.this.requestFocusInWindow();
                }
            });
            String string = Main.pref.get(ToggleDialog.this.preferencePrefix + ".bounds", null);
            if (string != null) {
                String[] stringArray = string.split(",");
                this.setBounds(ToggleDialog.this.getDetachedGeometry(new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]))));
            } else {
                ToggleDialog.this.setPreferredSize(ToggleDialog.this.getDefaultDetachedSize());
                this.pack();
                this.setLocationRelativeTo(Main.parent);
            }
            this.setTitle(ToggleDialog.this.titleBar.getTitle());
            HelpBuilder.setHelpContext(this.getRootPane(), ToggleDialog.this.helpTopic());
        }

        protected void rememberGeometry() {
            Main.pref.put(ToggleDialog.this.preferencePrefix + ".bounds", ToggleDialog.this.detachedDialog.getX() + "," + ToggleDialog.this.detachedDialog.getY() + "," + ToggleDialog.this.detachedDialog.getWidth() + "," + ToggleDialog.this.detachedDialog.getHeight());
        }
    }

    private class TitleBar
    extends JPanel {
        private final JLabel lblTitle;
        private final JComponent lblTitle_weak;

        public TitleBar(String string, String string2) {
            this.setLayout(new GridBagLayout());
            ToggleDialog.this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
            this.add(ToggleDialog.this.lblMinimized);
            ImageIcon imageIcon = ImageProvider.get("dialogs", string2);
            ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
            this.lblTitle = new JLabel("", imageIcon2, 11);
            this.lblTitle.setIconTextGap(8);
            JPanel jPanel = new JPanel();
            jPanel.add(this.lblTitle);
            jPanel.setVisible(false);
            this.add((Component)jPanel, GBC.std());
            this.lblTitle_weak = new JComponent(){

                public void paintComponent(Graphics graphics) {
                    TitleBar.this.lblTitle.paint(graphics);
                }
            };
            this.lblTitle_weak.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
            this.lblTitle_weak.setMinimumSize(new Dimension(0, 20));
            this.add((Component)this.lblTitle_weak, GBC.std().fill(2));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ToggleDialog.this.isCollapsed) {
                        ToggleDialog.this.expand();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.collapse();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    }
                }
            });
            JButton jButton = new JButton(ImageProvider.get("misc", "sticky"));
            jButton.setToolTipText(I18n.tr("Undock the panel"));
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleDialog.this.detach();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton(ImageProvider.get("misc", "close"));
            jButton2.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar."));
            jButton2.setBorder(BorderFactory.createEmptyBorder());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleDialog.this.hideDialog();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
            });
            this.add(jButton2);
            this.setToolTipText(I18n.tr("Click to minimize/maximize the panel content"));
            this.setTitle(string);
        }

        public void setTitle(String string) {
            this.lblTitle.setText(string);
            this.lblTitle_weak.repaint();
        }

        public String getTitle() {
            return this.lblTitle.getText();
        }
    }

    public final class ToggleDialogAction
    extends JosmAction {
        private ToggleDialogAction(String string, String string2, String string3, Shortcut shortcut, String string4) {
            super(string, string2, string3, shortcut, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ToggleDialog.this.isShowing) {
                ToggleDialog.this.hideDialog();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
            } else {
                ToggleDialog.this.showDialog();
                ToggleDialog.this.expand();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
            }
        }
    }
}

