/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableMemberCellRenderer
extends MemberTableCellRenderer {
    private HashMap<OsmPrimitiveType, ImageIcon> icons;

    public MemberTableMemberCellRenderer() {
        this.loadIcons();
    }

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderPrimitive(OsmPrimitive osmPrimitive) {
        this.setIcon(this.icons.get((Object)OsmPrimitiveType.from(osmPrimitive)));
        this.setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(this.buildToolTipText(osmPrimitive));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        this.renderForeground(bl);
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        this.renderBackground(this.getModel(jTable), osmPrimitive, bl);
        this.renderPrimitive(osmPrimitive);
        return this;
    }
}

