/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNodeMap {
    private HashMap<Node, TreeSet<Integer>> points;
    private HashMap<Node, Integer> nodes;
    private Vector<Integer> remaining;
    private ArrayList<RelationMember> members;

    RelationNodeMap(ArrayList<RelationMember> arrayList) {
        this.members = arrayList;
        this.points = new HashMap();
        this.nodes = new HashMap();
        this.remaining = new Vector();
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMember relationMember = arrayList.get(i);
            if (relationMember.getMember().incomplete) {
                this.remaining.add(i);
                continue;
            }
            this.add(i, relationMember);
        }
    }

    Integer find(Node node, int n) {
        Integer n2 = null;
        try {
            n2 = this.nodes.get(node);
            if (n2 == null) {
                n2 = this.points.get(node).first();
                if (this.members.get(n).getMember() == this.members.get(n2).getMember()) {
                    n2 = this.points.get(node).last();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return n2;
    }

    void add(int n, RelationMember relationMember) {
        if (relationMember.isWay()) {
            Way way = relationMember.getWay();
            if (way.lastNode() == way.firstNode()) {
                this.nodes.put(way.firstNode(), n);
            } else {
                if (!this.points.containsKey(way.firstNode())) {
                    this.points.put(way.firstNode(), new TreeSet());
                }
                this.points.get(way.firstNode()).add(n);
                if (!this.points.containsKey(way.lastNode())) {
                    this.points.put(way.lastNode(), new TreeSet());
                }
                this.points.get(way.lastNode()).add(n);
            }
        } else if (relationMember.isNode()) {
            Node node = relationMember.getNode();
            this.nodes.put(node, n);
        } else {
            this.remaining.add(n);
        }
    }

    boolean remove(int n, RelationMember relationMember) {
        boolean bl;
        if (relationMember.isWay()) {
            Way way = relationMember.getWay();
            if (way.firstNode() == way.lastNode()) {
                bl = this.nodes.remove(way.firstNode()) != null;
            } else {
                bl = this.points.get(way.firstNode()).remove(n);
                bl &= this.points.get(way.lastNode()).remove(n);
            }
        } else {
            bl = this.nodes.remove(relationMember.getMember()) != null;
        }
        return bl;
    }

    void move(int n, int n2) {
        if (n != n2) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n2);
            this.remove(n2, relationMember);
            this.add(n2, relationMember2);
        }
    }

    boolean isEmpty() {
        return this.points.isEmpty() && this.nodes.isEmpty();
    }

    Vector<Integer> getRemaining() {
        return this.remaining;
    }

    Integer pop() {
        Node node = null;
        Integer n = null;
        if (!this.nodes.isEmpty()) {
            node = this.nodes.keySet().iterator().next();
            n = this.nodes.get(node);
            this.nodes.remove(node);
        } else if (!this.points.isEmpty()) {
            for (TreeSet<Integer> treeSet : this.points.values()) {
                if (treeSet.isEmpty()) continue;
                n = treeSet.first();
                Way way = this.members.get(n).getWay();
                this.points.get(way.firstNode()).remove(n);
                this.points.get(way.lastNode()).remove(n);
                break;
            }
        }
        return n;
    }
}

