/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_DOUBLE_ENTRY = new Color(255, 234, 213);
    private HashMap<OsmPrimitiveType, ImageIcon> icons;
    private MemberTableModel model;

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    public SelectionTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.loadIcons();
    }

    public String buildToolTipText(OsmPrimitive osmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(osmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(osmPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = osmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(OsmPrimitive osmPrimitive, boolean bl) {
        Color color = Color.WHITE;
        if (bl) {
            color = BGCOLOR_SELECTED;
        } else if (osmPrimitive != null && this.model != null && this.model.getNumMembersWithPrimitive(osmPrimitive) > 0) {
            color = BGCOLOR_DOUBLE_ENTRY;
        }
        this.setBackground(color);
    }

    protected void renderForeground(boolean bl) {
        Color color = Color.BLACK;
        this.setForeground(color);
    }

    protected void renderPrimitive(OsmPrimitive osmPrimitive) {
        this.setIcon(this.icons.get((Object)OsmPrimitiveType.from(osmPrimitive)));
        this.setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(this.buildToolTipText(osmPrimitive));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        this.renderForeground(bl);
        this.renderBackground((OsmPrimitive)object, bl);
        this.renderPrimitive((OsmPrimitive)object);
        return this;
    }

    public void setMemberTableModel(MemberTableModel memberTableModel) {
        this.model = memberTableModel;
    }
}

