/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.BookmarkList;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BookmarkSelection
implements DownloadSelection {
    private Preferences.Bookmark tempBookmark = null;
    private BookmarkList bookmarks;

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        downloadDialog.tabpane.addTab(I18n.tr("Bookmarks"), jPanel);
        this.bookmarks = new BookmarkList();
        this.bookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Preferences.Bookmark bookmark = (Preferences.Bookmark)BookmarkSelection.this.bookmarks.getSelectedValue();
                if (bookmark != null) {
                    downloadDialog.minlat = bookmark.latlon[0];
                    downloadDialog.minlon = bookmark.latlon[1];
                    downloadDialog.maxlat = bookmark.latlon[2];
                    downloadDialog.maxlon = bookmark.latlon[3];
                    downloadDialog.boundingBoxChanged(BookmarkSelection.this);
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this.bookmarks), GBC.eol().fill());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JButton jButton = new JButton(I18n.tr("Add"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BookmarkSelection.this.tempBookmark == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please enter the desired coordinates first."), I18n.tr("Information"), 1);
                    return;
                }
                ((BookmarkSelection)BookmarkSelection.this).tempBookmark.name = JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the location."), I18n.tr("Name of location"), 3);
                if (((BookmarkSelection)BookmarkSelection.this).tempBookmark.name != null && !((BookmarkSelection)BookmarkSelection.this).tempBookmark.name.equals("")) {
                    ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).addElement(BookmarkSelection.this.tempBookmark);
                    BookmarkSelection.this.bookmarks.save();
                }
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18n.tr("Remove"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = BookmarkSelection.this.bookmarks.getSelectedValue();
                if (e == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Select a bookmark first."), I18n.tr("Information"), 1);
                    return;
                }
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).removeElement(e);
                BookmarkSelection.this.bookmarks.save();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, GBC.eop().fill(2));
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        this.tempBookmark = new Preferences.Bookmark();
        this.tempBookmark.latlon[0] = downloadDialog.minlat;
        this.tempBookmark.latlon[1] = downloadDialog.minlon;
        this.tempBookmark.latlon[2] = downloadDialog.maxlat;
        this.tempBookmark.latlon[3] = downloadDialog.maxlon;
        this.bookmarks.clearSelection();
    }
}

