/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HistoryBrowserDialogManager {
    private static HistoryBrowserDialogManager instance;
    private Map<Long, HistoryBrowserDialog> dialogs = new HashMap<Long, HistoryBrowserDialog>();

    public static HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
    }

    public boolean existsDialog(long l) {
        return this.dialogs.containsKey(l);
    }

    public void show(long l, HistoryBrowserDialog historyBrowserDialog) {
        if (this.dialogs.values().contains(historyBrowserDialog)) {
            this.show(l);
        } else {
            this.placeOnScreen(historyBrowserDialog);
            historyBrowserDialog.setVisible(true);
            this.dialogs.put(l, historyBrowserDialog);
        }
    }

    public void show(long l) {
        if (this.dialogs.keySet().contains(l)) {
            this.dialogs.get(l).toFront();
        }
    }

    protected boolean hasDialogWithCloseUpperLeftCorner(Point point) {
        for (HistoryBrowserDialog historyBrowserDialog : this.dialogs.values()) {
            Point point2 = historyBrowserDialog.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    public void placeOnScreen(HistoryBrowserDialog historyBrowserDialog) {
        WindowGeometry windowGeometry = WindowGeometry.centerOnScreen(new Dimension(800, 500));
        windowGeometry.apply(historyBrowserDialog);
        Point point = historyBrowserDialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(point)) {
            point.x += 20;
            point.y += 20;
        }
        historyBrowserDialog.setLocation(point);
    }

    public void hide(HistoryBrowserDialog historyBrowserDialog) {
        long l = 0L;
        for (long l2 : this.dialogs.keySet()) {
            if (this.dialogs.get(l2) != historyBrowserDialog) continue;
            l = l2;
            break;
        }
        if (l > 0L) {
            this.dialogs.remove(l);
        }
        historyBrowserDialog.setVisible(false);
        historyBrowserDialog.dispose();
    }
}

