/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean cancelled = false;
    private Exception lastException = null;
    private Map<Long, OsmPrimitiveType> toLoad = new HashMap<Long, OsmPrimitiveType>();
    private HistoryDataSet loadedData;

    public HistoryLoadTask() {
        super(I18n.tr("Load history"), true);
    }

    public HistoryLoadTask add(long l, OsmPrimitiveType osmPrimitiveType) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
        }
        if (osmPrimitiveType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        if (!this.toLoad.containsKey(l)) {
            this.toLoad.put(l, osmPrimitiveType);
        }
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        if (!this.toLoad.containsKey(historyOsmPrimitive.getId())) {
            this.toLoad.put(historyOsmPrimitive.getId(), historyOsmPrimitive.getType());
        }
        return this;
    }

    public HistoryLoadTask add(History history) {
        if (history == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "history"));
        }
        if (!this.toLoad.containsKey(history.getId())) {
            this.toLoad.put(history.getId(), history.getEarliest().getType());
        }
        return this;
    }

    public HistoryLoadTask add(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        return this.add(osmPrimitive.getId(), OsmPrimitiveType.from(osmPrimitive));
    }

    public HistoryLoadTask add(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitives"));
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            this.add(osmPrimitive);
        }
        return this;
    }

    @Override
    protected void cancel() {
        OsmApi.getOsmApi().cancel();
        this.cancelled = true;
    }

    @Override
    protected void finish() {
        if (this.isCancelled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        try {
            for (Map.Entry<Long, OsmPrimitiveType> entry : this.toLoad.entrySet()) {
                if (this.cancelled) break;
                if (entry.getKey() == 0L) continue;
                String string = "";
                switch (entry.getValue()) {
                    case NODE: {
                        string = I18n.marktr("Loading history for node {0}");
                        break;
                    }
                    case WAY: {
                        string = I18n.marktr("Loading history for way {0}");
                        break;
                    }
                    case RELATION: {
                        string = I18n.marktr("Loading history for relation {0}");
                    }
                }
                this.progressMonitor.indeterminateSubTask(I18n.tr(string, Long.toString(entry.getKey())));
                OsmServerHistoryReader osmServerHistoryReader = null;
                HistoryDataSet historyDataSet = null;
                try {
                    osmServerHistoryReader = new OsmServerHistoryReader(entry.getValue(), entry.getKey());
                    historyDataSet = osmServerHistoryReader.parseHistory(this.progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (OsmTransferException osmTransferException) {
                    if (this.cancelled) {
                        return;
                    }
                    throw osmTransferException;
                }
                this.loadedData.mergeInto(historyDataSet);
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.lastException = osmTransferException;
            return;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

