/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(VersionTableCellRenderer.class.getName());
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_IS_REFERENCE_POINT = new Color(255, 197, 197);
    protected HashMap<OsmPrimitiveType, ImageIcon> icons = null;

    public VersionTableCellRenderer() {
        this.loadIcons();
        this.setOpaque(true);
    }

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(HistoryOsmPrimitive historyOsmPrimitive) {
        ImageIcon imageIcon = null;
        if (historyOsmPrimitive != null) {
            imageIcon = this.icons.get((Object)historyOsmPrimitive.getType());
        }
        this.setIcon(imageIcon);
    }

    protected void renderText(HistoryOsmPrimitive historyOsmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        if (historyOsmPrimitive == null) {
            stringBuilder.append("");
        } else {
            String string = I18n.tr("Version {0}, {1} (by {2})", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()), historyOsmPrimitive.getUser());
            stringBuilder.append(string);
        }
        this.setText(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        if (historyOsmPrimitive == null) {
            stringBuilder.append("");
        } else {
            stringBuilder.append(I18n.tr("Version {0} created on {1} by {2}", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()), historyOsmPrimitive.getUser()));
        }
        this.setToolTipText(stringBuilder.toString());
    }

    protected void renderBackground(JTable jTable, int n, boolean bl) {
        Color color = Color.WHITE;
        if (bl) {
            color = BGCOLOR_SELECTED;
        } else if (this.getModel(jTable).isReferencePointInTime(n)) {
            color = BGCOLOR_IS_REFERENCE_POINT;
        }
        this.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
        this.renderIcon(historyOsmPrimitive);
        this.renderText(historyOsmPrimitive);
        this.renderBackground(jTable, n, bl);
        return this;
    }

    protected HistoryBrowserModel.VersionTableModel getModel(JTable jTable) {
        return (HistoryBrowserModel.VersionTableModel)jTable.getModel();
    }
}

