/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.DateParser;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageLayer
extends Layer {
    private static final int ICON_SIZE = 16;
    private static ImageLoader imageLoader = new ImageLoader();
    public ArrayList<ImageEntry> data;
    private LinkedList<TimedPoint> gps = new LinkedList();
    private long delta = Long.parseLong(Main.pref.get("tagimages.delta", "0"));
    private long gpstimezone = Long.parseLong(Main.pref.get("tagimages.gpstimezone", "0")) * 60L * 60L * 1000L;
    private boolean mousePressed = false;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private MouseAdapter mouseAdapter;
    private ImageViewerDialog imageViewerDialog;

    public static void create(Collection<File> collection, GpxLayer gpxLayer) {
        Loader loader = new Loader(collection, gpxLayer);
        Main.worker.execute(loader);
    }

    private GeoImageLayer(final ArrayList<ImageEntry> arrayList, LinkedList<TimedPoint> linkedList) {
        super(I18n.tr("Geotagged Images"));
        Collections.sort(arrayList);
        Collections.sort(linkedList);
        this.data = arrayList;
        this.gps = linkedList;
        final GeoImageLayer geoImageLayer = this;
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = true;
                if (GeoImageLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = false;
                if (!GeoImageLayer.this.isVisible()) {
                    return;
                }
                for (int i = arrayList.size(); i > 0; --i) {
                    ImageEntry imageEntry = (ImageEntry)arrayList.get(i - 1);
                    if (imageEntry.pos == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.pos);
                    Rectangle rectangle = new Rectangle(point.x - 8, point.y - 8, 16, 16);
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    GeoImageLayer.this.showImage(i - 1);
                    break;
                }
                Main.map.mapView.repaint();
            }
        };
        Main.map.mapView.addMouseListener(this.mouseAdapter);
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer == geoImageLayer) {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        });
    }

    private void showImage(int n) {
        if (this.imageViewerDialog == null) {
            this.imageViewerDialog = new ImageViewerDialog(this.data.get(n));
        }
        this.imageViewerDialog.showImage(n);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "tagimages_small");
    }

    @Override
    public Object getInfoComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.getToolTipText()), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("GPS start: {0}", dateFormat.format(this.gps.getFirst().time))), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("GPS end: {0}", dateFormat.format(this.gps.getLast().time))), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("current delta: {0}s", (double)this.delta / 1000.0)), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("timezone difference: ") + (this.gpstimezone > 0L ? "+" : "") + this.gpstimezone / 1000L / 60L / 60L), GBC.eop());
        JList<Object> jList = new JList<Object>(this.data.toArray());
        jList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                ImageEntry imageEntry = (ImageEntry)object;
                this.setIcon(new ImageIcon(imageEntry.getIcon()));
                this.setText(imageEntry.image.getName() + " (" + dateFormat.format(new Date(imageEntry.time.getTime() + (GeoImageLayer.this.delta + GeoImageLayer.this.gpstimezone))) + ")");
                if (imageEntry.pos == null) {
                    this.setForeground(Color.red);
                }
                return this;
            }
        });
        jList.setVisibleRowCount(5);
        jPanel.add((Component)new JScrollPane(jList), GBC.eop().fill(1));
        return jPanel;
    }

    @Override
    public String getToolTipText() {
        int n = 0;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.pos == null) continue;
            ++n;
        }
        return this.data.size() + " " + I18n.trn("image", "images", this.data.size()) + ". " + I18n.tr("{0} within the track.", n);
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        GeoImageLayer geoImageLayer = (GeoImageLayer)layer;
        this.data.addAll(geoImageLayer.data);
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        Rectangle rectangle;
        Point point;
        ImageEntry imageEntry;
        int n;
        int n2 = -1;
        Point point2 = mapView.getMousePosition();
        if (point2 != null && this.mousePressed) {
            for (n = this.data.size() - 1; n >= 0; --n) {
                imageEntry = this.data.get(n);
                if (imageEntry.pos == null) continue;
                point = mapView.getPoint(imageEntry.pos);
                rectangle = new Rectangle(point.x - 8, point.y - 8, 16, 16);
                if (!rectangle.contains(point2)) continue;
                n2 = n;
                break;
            }
        }
        for (n = 0; n < this.data.size(); ++n) {
            imageEntry = this.data.get(n);
            if (imageEntry.pos == null) continue;
            point = mapView.getPoint(imageEntry.pos);
            rectangle = new Rectangle(point.x - 8, point.y - 8, 16, 16);
            graphics.drawImage(imageEntry.getIcon(), rectangle.x, rectangle.y, null);
            Border border = null;
            border = n == n2 ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0);
            Insets insets = border.getBorderInsets(mapView);
            rectangle.grow((insets.top + insets.bottom) / 2, (insets.left + insets.right) / 2);
            border.paintBorder(mapView, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.pos);
        }
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Sync clock"), ImageProvider.get("clock"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return I18n.tr("JPEG images (*.jpg)");
                    }
                });
                jFileChooser.showOpenDialog(Main.parent);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                Main.pref.put("tagimages.lastdirectory", file.getPath());
                GeoImageLayer.this.sync(file);
                Main.map.repaint();
            }
        });
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), jMenuItem, new JSeparator(), new JMenuItem(new RenameLayerAction(null, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    private void calculatePosition() {
        for (ImageEntry imageEntry : this.data) {
            TimedPoint timedPoint = null;
            for (TimedPoint timedPoint2 : this.gps) {
                Date date = new Date(timedPoint2.time.getTime() - (this.delta + this.gpstimezone));
                if (date.after(imageEntry.time) && timedPoint != null) {
                    imageEntry.pos = new CachedLatLon(timedPoint.pos.getCenter(timedPoint2.pos));
                    break;
                }
                timedPoint = timedPoint2;
            }
            if (imageEntry.pos != null) continue;
            imageEntry.pos = this.gps.getLast().pos;
        }
    }

    private void sync(File file) {
        Date date;
        try {
            date = ExifReader.readTime(file);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The date in file \"{0}\" could not be parsed.", file.getName()), I18n.tr("Error"), 0);
            return;
        }
        if (date == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There is no EXIF time within the file \"{0}\".", file.getName()), I18n.tr("Error"), 0);
            return;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Image")), GBC.eol());
        jPanel.add((Component)new JLabel(new ImageIcon(imageLoader.waitForImage(file, 300))), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("Enter shown date (mm/dd/yyyy HH:MM:SS)")), GBC.eol());
        JTextField jTextField = new JTextField(dateFormat.format(new Date(date.getTime() + this.delta)));
        jPanel.add((Component)jTextField, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("GPS unit timezone (difference to photo)")), GBC.eol());
        String string = Main.pref.get("tagimages.gpstimezone", "0");
        if (string.charAt(0) != '-') {
            string = "+" + string;
        }
        JTextField jTextField2 = new JTextField(string);
        jPanel.add((Component)jTextField2, GBC.eol().fill(2));
        int n;
        while ((n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Synchronize Time with GPS Unit"), 2, 3)) == 0 && !jTextField.getText().equals("")) {
            try {
                this.delta = DateParser.parse(jTextField.getText()).getTime() - date.getTime();
                String string2 = jTextField2.getText();
                if (!string2.equals("") && string2.charAt(0) == '+') {
                    string2 = string2.substring(1);
                }
                if (string2.equals("")) {
                    string2 = "0";
                }
                this.gpstimezone = Long.valueOf(string2) * 60L * 60L * 1000L;
                Main.pref.put("tagimages.delta", "" + this.delta);
                Main.pref.put("tagimages.gpstimezone", string2);
                this.calculatePosition();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."), I18n.tr("Error"), 0);
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."), I18n.tr("Error"), 0);
                continue;
            }
            break;
        }
        return;
    }

    private class ImageViewerDialog {
        private int currentImage;
        private ImageEntry currentImageEntry;
        private final JDialog dlg;
        private final JButton nextButton;
        private final JButton prevButton;
        private final JToggleButton scaleToggle;
        private final JToggleButton centerToggle;
        private final JViewport imageViewport;
        private final JLabel imageLabel;

        public ImageViewerDialog(ImageEntry imageEntry) {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.imageLabel = new JLabel(new ImageIcon(imageLoader.waitForImage(imageEntry.image, 580)));
            JScrollPane jScrollPane = new JScrollPane(this.imageLabel);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            this.imageViewport = jScrollPane.getViewport();
            jPanel.add((Component)jScrollPane, "Center");
            this.scaleToggle = new JToggleButton(ImageProvider.get("dialogs", "zoom-best-fit"));
            this.nextButton = new JButton(ImageProvider.get("dialogs", "next"));
            this.prevButton = new JButton(ImageProvider.get("dialogs", "previous"));
            this.centerToggle = new JToggleButton(ImageProvider.get("dialogs", "centreview"));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.prevButton);
            jPanel2.add(this.scaleToggle);
            jPanel2.add(this.centerToggle);
            jPanel2.add(this.nextButton);
            jPanel.add((Component)jPanel2, "South");
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
            this.dlg = jOptionPane.createDialog(Main.parent, "");
            this.scaleToggle.addActionListener(new ImageAction(0));
            this.scaleToggle.setSelected(true);
            this.centerToggle.addActionListener(new ImageAction(0));
            this.nextButton.setActionCommand("Next");
            this.prevButton.setActionCommand("Previous");
            this.nextButton.setMnemonic(39);
            this.prevButton.setMnemonic(37);
            this.scaleToggle.setMnemonic(70);
            this.centerToggle.setMnemonic(67);
            this.nextButton.setToolTipText("Show next image");
            this.prevButton.setToolTipText("Show previous image");
            this.centerToggle.setToolTipText("Centre image location in main display");
            this.scaleToggle.setToolTipText("Scale image to fit");
            this.prevButton.addActionListener(new ImageAction(-1));
            this.nextButton.addActionListener(new ImageAction(1));
            this.centerToggle.setSelected(false);
            this.dlg.addComponentListener(new ComponentListener(){
                boolean ignoreEvent = true;

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                    if (ImageViewerDialog.this.scaleToggle.getModel().isSelected() && !this.ignoreEvent) {
                        ImageViewerDialog.this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(((ImageViewerDialog)ImageViewerDialog.this).currentImageEntry.image, Math.max(ImageViewerDialog.this.imageViewport.getWidth(), ImageViewerDialog.this.imageViewport.getHeight()))));
                    }
                    this.ignoreEvent = false;
                }

                public void componentShown(ComponentEvent componentEvent) {
                }
            });
            this.dlg.setModal(false);
            this.dlg.setResizable(true);
            this.dlg.pack();
        }

        public void showImage(int n) {
            this.dlg.setVisible(true);
            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
            if (n < 0) {
                n = 0;
            } else if (n >= GeoImageLayer.this.data.size() - 1) {
                n = GeoImageLayer.this.data.size() - 1;
            }
            this.currentImage = n;
            this.currentImageEntry = GeoImageLayer.this.data.get(this.currentImage);
            this.prevButton.setEnabled(this.currentImage > 0);
            this.nextButton.setEnabled(this.currentImage < GeoImageLayer.this.data.size() - 1);
            if (this.scaleToggle.getModel().isSelected()) {
                this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(this.currentImageEntry.image, Math.max(this.imageViewport.getWidth(), this.imageViewport.getHeight()))));
            } else {
                this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(this.currentImageEntry.image)));
            }
            if (this.centerToggle.getModel().isSelected()) {
                Main.map.mapView.zoomTo(this.currentImageEntry.pos);
            }
            this.dlg.setTitle(this.currentImageEntry.image + " (" + this.currentImageEntry.pos.toDisplayString() + ")");
            this.dlg.setCursor(Cursor.getDefaultCursor());
        }

        private class ImageAction
        implements ActionListener {
            private final int offset;

            public ImageAction(int n) {
                this.offset = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewerDialog.this.showImage(ImageViewerDialog.this.currentImage + this.offset);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimedPoint
    implements Comparable<TimedPoint> {
        Date time;
        CachedLatLon pos;

        public TimedPoint(Date date, LatLon latLon) {
            this.time = date;
            this.pos = new CachedLatLon(latLon);
        }

        @Override
        public int compareTo(TimedPoint timedPoint) {
            return this.time.compareTo(timedPoint.time);
        }
    }

    public static final class GpsTimeIncorrect
    extends Exception {
        public GpsTimeIncorrect(String string, Throwable throwable) {
            super(string, throwable);
        }

        public GpsTimeIncorrect(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private GeoImageLayer layer;
        private final Collection<File> files;
        private final GpxLayer gpxLayer;

        public Loader(Collection<File> collection, GpxLayer gpxLayer) {
            super(I18n.tr("Images for {0}", gpxLayer.getName()));
            this.files = collection;
            this.gpxLayer = gpxLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Read GPX..."));
            this.progressMonitor.setTicksCount(10 + this.files.size());
            LinkedList<TimedPoint> linkedList = new LinkedList<TimedPoint>();
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(10, true);
            int n = 0;
            for (GpxTrack object : this.gpxLayer.data.tracks) {
                for (Collection<WayPoint> collection : object.trackSegs) {
                    n += collection.size();
                }
            }
            progressMonitor.beginTask(null, n);
            try {
                for (GpxTrack gpxTrack : this.gpxLayer.data.tracks) {
                    for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                        for (WayPoint wayPoint : collection) {
                            LatLon latLon = wayPoint.getCoor();
                            if (!wayPoint.attr.containsKey("time")) {
                                throw new IOException(I18n.tr("No time for point {0} x {1}", latLon.lat(), latLon.lon()));
                            }
                            Date date = null;
                            try {
                                date = DateParser.parse((String)wayPoint.attr.get("time"));
                            }
                            catch (ParseException parseException) {
                                throw new IOException(I18n.tr("Cannot read time \"{0}\" from point {1} x {2}", wayPoint.attr.get("time"), latLon.lat(), latLon.lon()));
                            }
                            linkedList.add(new TimedPoint(date, latLon));
                            progressMonitor.worked(1);
                        }
                    }
                }
            }
            finally {
                progressMonitor.finishTask();
            }
            if (linkedList.isEmpty()) {
                this.progressMonitor.setErrorMessage(I18n.tr("No images with readable timestamps found."));
                return;
            }
            ArrayList arrayList = new ArrayList(this.files.size());
            for (File file : this.files) {
                if (this.progressMonitor.isCancelled()) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", file.getName()));
                ImageEntry imageEntry = new ImageEntry(file);
                try {
                    imageEntry.time = ExifReader.readTime(file);
                    this.progressMonitor.worked(1);
                }
                catch (ParseException parseException) {
                    continue;
                }
                if (imageEntry.time == null) continue;
                arrayList.add(imageEntry);
            }
            this.layer = new GeoImageLayer(arrayList, linkedList);
            this.layer.calculatePosition();
        }

        @Override
        protected void finish() {
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
            }
        }

        @Override
        protected void cancel() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageEntry
    implements Comparable<ImageEntry>,
    ImageLoader.ImageLoadedListener {
        private static final Image EMPTY_IMAGE = new BufferedImage(1, 1, 12);
        final File image;
        ImageLoader.Entry icon;
        Date time;
        CachedLatLon pos;

        public ImageEntry(File file) {
            this.image = file;
            this.icon = imageLoader.loadImage(file, 16, 16, -1, this);
        }

        @Override
        public int compareTo(ImageEntry imageEntry) {
            return this.time.compareTo(imageEntry.time);
        }

        public Image getIcon() {
            if (this.icon.scaledImage == null) {
                return EMPTY_IMAGE;
            }
            return this.icon.scaledImage;
        }

        @Override
        public void imageLoaded() {
            MapFrame mapFrame = Main.map;
            if (mapFrame != null) {
                mapFrame.mapView.repaint();
            }
        }
    }

    public static class ImageLoader
    implements ImageObserver {
        private final List<Entry> queue = new ArrayList<Entry>();
        private final WeakHashMap<File, SoftReference<Image>> loadedImageCache = new WeakHashMap();
        private Entry currentEntry;

        private Image getOrLoadImage(File file) {
            Image image;
            SoftReference<Image> softReference = this.loadedImageCache.get(file);
            if (softReference != null && (image = softReference.get()) != null) {
                return image;
            }
            return Toolkit.getDefaultToolkit().createImage(this.currentEntry.file.getAbsolutePath());
        }

        private BufferedImage createResizedCopy(Image image, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            while (!graphics2D.drawImage(image, 0, 0, n, n2, null)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            graphics2D.dispose();
            return bufferedImage;
        }

        private void loadImage() {
            if (this.currentEntry != null) {
                return;
            }
            while (!this.queue.isEmpty()) {
                this.currentEntry = this.queue.get(0);
                this.queue.remove(0);
                Image image = this.getOrLoadImage(this.currentEntry.file);
                if (image.getWidth(this) == -1) break;
                this.finishImage(image, this.currentEntry);
                this.currentEntry = null;
            }
        }

        private void finishImage(Image image, Entry entry) {
            this.loadedImageCache.put(entry.file, new SoftReference<Image>(image));
            if (entry.maxSize != -1) {
                int n;
                int n2 = image.getWidth(null);
                if (n2 > (n = image.getHeight(null))) {
                    n = Math.round((float)entry.maxSize * ((float)n / (float)n2));
                    n2 = entry.maxSize;
                } else {
                    n2 = Math.round((float)entry.maxSize * ((float)n2 / (float)n));
                    n = entry.maxSize;
                }
                entry.scaledImage = this.createResizedCopy(image, n2, n);
            } else {
                entry.scaledImage = entry.width != -1 && entry.height != -1 ? this.createResizedCopy(image, entry.width, entry.height) : image;
            }
            if (entry.listener != null) {
                entry.listener.imageLoaded();
            }
        }

        public synchronized Entry loadImage(File file, int n, int n2, int n3, ImageLoadedListener imageLoadedListener) {
            Entry entry = new Entry(file, n, n2, n3, imageLoadedListener);
            this.queue.add(entry);
            this.loadImage();
            return entry;
        }

        public Image waitForImage(File file, int n, int n2) {
            return this.waitForImage(file, n, n2, -1);
        }

        public Image waitForImage(File file, int n) {
            return this.waitForImage(file, -1, -1, n);
        }

        public Image waitForImage(File file) {
            return this.waitForImage(file, -1, -1, -1);
        }

        private synchronized Image waitForImage(File file, int n, int n2, int n3) {
            Entry entry;
            if (this.currentEntry != null && this.currentEntry.file.equals(file)) {
                entry = this.currentEntry;
            } else {
                entry = new Entry(file, n, n2, n3, null);
                this.queue.add(0, entry);
            }
            this.loadImage();
            while (entry.scaledImage == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return entry.scaledImage;
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.finishImage(image, this.currentEntry);
                this.currentEntry = null;
                this.loadImage();
                this.notifyAll();
            } else if ((n & 0x40) != 0) {
                this.currentEntry.scaledImage = new BufferedImage(1, 1, 12);
                this.currentEntry = null;
            }
            return true;
        }

        public static interface ImageLoadedListener {
            public void imageLoaded();
        }

        public static class Entry {
            final File file;
            final int width;
            final int height;
            final int maxSize;
            private final ImageLoadedListener listener;
            volatile Image scaledImage;

            public Entry(File file, int n, int n2, int n3, ImageLoadedListener imageLoadedListener) {
                this.file = file;
                this.height = n2;
                this.width = n;
                this.maxSize = n3;
                this.listener = imageLoadedListener;
            }
        }
    }
}

