/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.PlayHeadDragMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

public class PlayHeadMarker
extends Marker {
    private Timer timer = null;
    private double animationInterval = 0.0;
    private static PlayHeadMarker playHead = null;
    private MapMode oldMode = null;
    private LatLon oldCoor;
    private boolean enabled = Main.pref.getBoolean("marker.traceaudio", true);
    private boolean wasPlaying = false;
    private int dropTolerance;

    public static PlayHeadMarker create() {
        if (playHead == null) {
            try {
                playHead = new PlayHeadMarker();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return playHead;
    }

    private PlayHeadMarker() {
        super(new LatLon(0.0, 0.0), "", Main.pref.get("marker.audiotracericon", "audio-tracer"), null, -1.0, 0.0);
        if (!this.enabled) {
            return;
        }
        this.dropTolerance = Main.pref.getInteger("marker.playHeadDropTolerance", 50);
        Main.map.mapView.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                if (mouseEvent.getButton() != 1 || point == null) {
                    return;
                }
                if (playHead.containsPoint(point)) {
                    PlayHeadMarker.this.oldMode = Main.map.mapMode;
                    PlayHeadMarker.this.oldCoor = PlayHeadMarker.this.getCoor();
                    PlayHeadDragMode playHeadDragMode = new PlayHeadDragMode(playHead);
                    Main.map.selectMapMode(playHeadDragMode);
                    playHeadDragMode.mousePressed(mouseEvent);
                }
            }
        });
    }

    public boolean containsPoint(Point point) {
        Point point2 = Main.map.mapView.getPoint(this.getEastNorth());
        Rectangle rectangle = new Rectangle(point2.x, point2.y, this.symbol.getIconWidth(), this.symbol.getIconHeight());
        return rectangle.contains(point);
    }

    public void startDrag() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.wasPlaying = AudioPlayer.playing();
        if (this.wasPlaying) {
            try {
                AudioPlayer.pause();
            }
            catch (Exception exception) {
                AudioPlayer.audioMalfunction(exception);
            }
        }
    }

    private void endDrag(boolean bl) {
        if (!this.wasPlaying || bl) {
            try {
                AudioPlayer.pause();
            }
            catch (Exception exception) {
                AudioPlayer.audioMalfunction(exception);
            }
        }
        if (bl) {
            this.setCoor(this.oldCoor);
        }
        Main.map.selectMapMode(this.oldMode);
        Main.map.mapView.repaint();
        this.timer.start();
    }

    public void drag(EastNorth eastNorth) {
        this.setEastNorth(eastNorth);
        Main.map.mapView.repaint();
    }

    public void reposition(EastNorth eastNorth) {
        Object object;
        WayPoint wayPoint = null;
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker != null && audioMarker.parentLayer != null && audioMarker.parentLayer.fromLayer != null) {
            object = Main.map.mapView.getPoint(eastNorth);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(((Point)object).x + this.dropTolerance, ((Point)object).y);
            wayPoint = audioMarker.parentLayer.fromLayer.nearestPointOnTrack(eastNorth, eastNorth2.east() - eastNorth.east());
        }
        object = null;
        if (wayPoint != null && audioMarker != null && audioMarker.parentLayer != null) {
            for (Marker marker : audioMarker.parentLayer.data) {
                if (!(marker instanceof AudioMarker)) continue;
                AudioMarker audioMarker2 = (AudioMarker)marker;
                if (audioMarker2.time > wayPoint.time) break;
                object = audioMarker2;
            }
        }
        if (object == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to drag the play head near to the GPX track whose associated sound track you were playing (after the first marker)."), I18n.tr("Warning"), 2);
            this.endDrag(true);
        } else {
            this.setCoor(wayPoint.getCoor());
            ((AudioMarker)object).play(wayPoint.time - ((AudioMarker)object).time);
            this.endDrag(false);
        }
    }

    public void synchronize(EastNorth eastNorth) {
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker == null) {
            return;
        }
        Point point = Main.map.mapView.getPoint(eastNorth);
        ButtonMarker buttonMarker = null;
        if (audioMarker.parentLayer != null) {
            double d = 1.0E100;
            for (Marker marker : audioMarker.parentLayer.data) {
                double d2;
                if (!(marker instanceof AudioMarker) || !((d2 = marker.getEastNorth().distanceSq(eastNorth)) < d)) continue;
                buttonMarker = (AudioMarker)marker;
                d = d2;
            }
        }
        if (buttonMarker != null && !buttonMarker.containsPoint(point)) {
            buttonMarker = null;
        }
        if (buttonMarker == null) {
            Point point2 = Main.map.mapView.getPoint(eastNorth);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(point2.x + this.dropTolerance, point2.y);
            WayPoint wayPoint = audioMarker.parentLayer.fromLayer.nearestPointOnTrack(eastNorth, eastNorth2.east() - eastNorth.east());
            if (wayPoint == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to SHIFT-drag the play head onto an audio marker or onto the track point where you want to synchronize."), I18n.tr("Warning"), 2);
                this.endDrag(true);
                return;
            }
            buttonMarker = audioMarker.parentLayer.addAudioMarker(wayPoint.time, wayPoint.getCoor());
        }
        if (buttonMarker == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to create new audio marker."), I18n.tr("Error"), 0);
            this.endDrag(true);
        } else if (audioMarker.parentLayer.synchronizeAudioMarkers((AudioMarker)buttonMarker)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", ((AudioMarker)buttonMarker).text), I18n.tr("Information"), 1);
            this.setCoor(buttonMarker.getCoor());
            this.endDrag(false);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played."), I18n.tr("Error"), 0);
            this.endDrag(true);
        }
    }

    public void paint(Graphics graphics, MapView mapView) {
        if (this.time < 0.0) {
            return;
        }
        Point point = mapView.getPoint(this.getEastNorth());
        this.symbol.paintIcon(mapView, graphics, point.x, point.y);
    }

    public void animate() {
        if (!this.enabled) {
            return;
        }
        if (this.timer == null) {
            this.animationInterval = Double.parseDouble(Main.pref.get("marker.audioanimationinterval", "1"));
            this.timer = new Timer((int)(this.animationInterval * 1000.0), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlayHeadMarker.this.timerAction();
                }
            });
            this.timer.setInitialDelay(0);
        } else {
            this.timer.stop();
        }
        this.timer.start();
    }

    public void timerAction() {
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker == null) {
            return;
        }
        double d = audioMarker.time + AudioPlayer.position() - audioMarker.offset - audioMarker.syncOffset;
        if (Math.abs(d - this.time) < this.animationInterval) {
            return;
        }
        if (audioMarker.parentLayer == null) {
            return;
        }
        GpxLayer gpxLayer = audioMarker.parentLayer.fromLayer;
        if (gpxLayer == null) {
            return;
        }
        WayPoint wayPoint = null;
        WayPoint wayPoint2 = null;
        for (GpxTrack gpxTrack : gpxLayer.data.tracks) {
            for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                for (WayPoint wayPoint3 : collection) {
                    if (d < wayPoint3.time) {
                        wayPoint2 = wayPoint3;
                        break;
                    }
                    wayPoint = wayPoint3;
                }
                if (wayPoint2 == null) continue;
                break;
            }
            if (wayPoint2 == null) continue;
            break;
        }
        if (wayPoint == null) {
            return;
        }
        this.setEastNorth(wayPoint2 == null ? wayPoint.getEastNorth() : wayPoint.getEastNorth().interpolate(wayPoint2.getEastNorth(), (d - wayPoint.time) / (wayPoint2.time - wayPoint.time)));
        this.time = d;
        Main.map.mapView.repaint();
    }
}

