/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElemStyles {
    HashMap<String, StyleSet> styleSet = new HashMap();

    public void add(String string, Rule rule, Collection<Rule> collection, LineElemStyle lineElemStyle) {
        if (collection != null) {
            lineElemStyle.rules = collection;
            this.getStyleSet(string, true).linesList.add(lineElemStyle);
        } else {
            String string2;
            lineElemStyle.code = string2 = rule.getKey();
            this.getStyleSet(string, true).lines.put(string2, lineElemStyle);
        }
    }

    public void addModifier(String string, Rule rule, Collection<Rule> collection, LineElemStyle lineElemStyle) {
        if (collection != null) {
            lineElemStyle.rules = collection;
            this.getStyleSet(string, true).modifiersList.add(lineElemStyle);
        } else {
            String string2;
            lineElemStyle.code = string2 = rule.getKey();
            this.getStyleSet(string, true).modifiers.put(string2, lineElemStyle);
        }
    }

    public void add(String string, Rule rule, Collection<Rule> collection, AreaElemStyle areaElemStyle) {
        if (collection != null) {
            areaElemStyle.rules = collection;
            this.getStyleSet(string, true).areasList.add(areaElemStyle);
        } else {
            String string2;
            areaElemStyle.code = string2 = rule.getKey();
            this.getStyleSet(string, true).areas.put(string2, areaElemStyle);
        }
    }

    public void add(String string, Rule rule, Collection<Rule> collection, IconElemStyle iconElemStyle) {
        if (collection != null) {
            iconElemStyle.rules = collection;
            this.getStyleSet(string, true).iconsList.add(iconElemStyle);
        } else {
            String string2;
            iconElemStyle.code = string2 = rule.getKey();
            this.getStyleSet(string, true).icons.put(string2, iconElemStyle);
        }
    }

    private StyleSet getStyleSet(String string, boolean bl) {
        if (string == null) {
            string = Main.pref.get("mappaint.style", "standard");
        }
        StyleSet styleSet = this.styleSet.get(string);
        if (bl && styleSet == null) {
            styleSet = new StyleSet();
            this.styleSet.put(string, styleSet);
        }
        return styleSet;
    }

    public StyleSet getStyleSet() {
        return this.getStyleSet(null, false);
    }

    public Collection<String> getStyleNames() {
        return this.styleSet.keySet();
    }

    public class StyleSet {
        private HashMap<String, IconElemStyle> icons = new HashMap();
        private HashMap<String, LineElemStyle> lines = new HashMap();
        private HashMap<String, AreaElemStyle> areas;
        private HashMap<String, LineElemStyle> modifiers = new HashMap();
        private LinkedList<IconElemStyle> iconsList;
        private LinkedList<LineElemStyle> linesList;
        private LinkedList<AreaElemStyle> areasList;
        private LinkedList<LineElemStyle> modifiersList;

        public StyleSet() {
            this.areas = new HashMap();
            this.iconsList = new LinkedList();
            this.linesList = new LinkedList();
            this.modifiersList = new LinkedList();
            this.areasList = new LinkedList();
        }

        private IconElemStyle getNode(OsmPrimitive osmPrimitive) {
            IconElemStyle object = null;
            for (Map.Entry<String, String> object2 : osmPrimitive.entrySet()) {
                String string = object2.getKey();
                String string2 = object2.getValue();
                IconElemStyle iconElemStyle = this.icons.get("n" + string + "=" + string2);
                if (iconElemStyle != null && (object == null || iconElemStyle.priority > object.priority)) {
                    object = iconElemStyle;
                }
                if ((iconElemStyle = this.icons.get("b" + string + "=" + OsmUtils.getNamedOsmBoolean(string2))) != null && (object == null || iconElemStyle.priority > object.priority)) {
                    object = iconElemStyle;
                }
                if ((iconElemStyle = this.icons.get("x" + string)) == null || object != null && iconElemStyle.priority <= object.priority) continue;
                object = iconElemStyle;
            }
            for (IconElemStyle iconElemStyle : this.iconsList) {
                if (object != null && iconElemStyle.priority <= object.priority || !iconElemStyle.check(osmPrimitive)) continue;
                object = iconElemStyle;
            }
            return object;
        }

        private ElemStyle get(OsmPrimitive osmPrimitive, boolean bl) {
            AreaElemStyle object = null;
            LineElemStyle object2 = null;
            String string = null;
            HashMap<String, LineElemStyle> hashMap = new HashMap<String, LineElemStyle>();
            for (Map.Entry<String, String> object3 : osmPrimitive.entrySet()) {
                LineElemStyle lineElemStyle;
                String string2 = object3.getKey();
                String string3 = object3.getValue();
                String string4 = "n" + string2 + "=" + string3;
                AreaElemStyle areaElemStyle = this.areas.get(string4);
                if (!(areaElemStyle == null || object != null && areaElemStyle.priority <= object.priority || bl && areaElemStyle.closed)) {
                    object = areaElemStyle;
                }
                if ((lineElemStyle = this.lines.get(string4)) != null && (object2 == null || lineElemStyle.priority > object2.priority)) {
                    object2 = lineElemStyle;
                    string = string4;
                }
                if ((lineElemStyle = this.modifiers.get(string4)) != null) {
                    hashMap.put(string4, lineElemStyle);
                }
                if (!((areaElemStyle = this.areas.get(string4 = "b" + string2 + "=" + OsmUtils.getNamedOsmBoolean(string3))) == null || object != null && areaElemStyle.priority <= object.priority || bl && areaElemStyle.closed)) {
                    object = areaElemStyle;
                }
                if ((lineElemStyle = this.lines.get(string4)) != null && (object2 == null || lineElemStyle.priority > object2.priority)) {
                    object2 = lineElemStyle;
                    string = string4;
                }
                if ((lineElemStyle = this.modifiers.get(string4)) != null) {
                    hashMap.put(string4, lineElemStyle);
                }
                if (!((areaElemStyle = this.areas.get(string4 = "x" + string2)) == null || object != null && areaElemStyle.priority <= object.priority || bl && areaElemStyle.closed)) {
                    object = areaElemStyle;
                }
                if ((lineElemStyle = this.lines.get(string4)) != null && (object2 == null || lineElemStyle.priority > object2.priority)) {
                    object2 = lineElemStyle;
                    string = string4;
                }
                if ((lineElemStyle = this.modifiers.get(string4)) == null) continue;
                hashMap.put(string4, lineElemStyle);
            }
            for (AreaElemStyle areaElemStyle : this.areasList) {
                if (object != null && areaElemStyle.priority <= object.priority || bl && areaElemStyle.closed || !areaElemStyle.check(osmPrimitive)) continue;
                object = areaElemStyle;
            }
            for (LineElemStyle lineElemStyle : this.linesList) {
                if (object2 != null && lineElemStyle.priority <= object2.priority || !lineElemStyle.check(osmPrimitive)) continue;
                object2 = lineElemStyle;
            }
            for (LineElemStyle lineElemStyle : this.modifiersList) {
                if (!lineElemStyle.check(osmPrimitive)) continue;
                hashMap.put(lineElemStyle.getCode(), lineElemStyle);
            }
            hashMap.remove(string);
            if (hashMap.size() != 0 && object2 != null) {
                LinkedList linkedList = new LinkedList(hashMap.values());
                Collections.sort(linkedList);
                object2 = new LineElemStyle(object2, linkedList);
            }
            if (object != null) {
                if (object2 != null) {
                    return new AreaElemStyle(object, object2);
                }
                return object;
            }
            return object2;
        }

        public ElemStyle get(OsmPrimitive osmPrimitive) {
            return !osmPrimitive.hasKeys() ? null : (osmPrimitive instanceof Node ? this.getNode(osmPrimitive) : this.get(osmPrimitive, osmPrimitive instanceof Way && !((Way)osmPrimitive).isClosed()));
        }

        public ElemStyle getArea(Way way) {
            ElemStyle elemStyle;
            if (way.hasKeys() && (elemStyle = this.get(way, false)) != null && elemStyle instanceof AreaElemStyle) {
                return elemStyle;
            }
            return null;
        }

        public IconElemStyle getIcon(OsmPrimitive osmPrimitive) {
            return osmPrimitive.hasKeys() ? this.getNode(osmPrimitive) : null;
        }

        public boolean isArea(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.hasKeys() && !(osmPrimitive instanceof Node)) {
                boolean bl = osmPrimitive instanceof Way && !((Way)osmPrimitive).isClosed();
                for (String object : osmPrimitive.keySet()) {
                    String string = osmPrimitive.get(object);
                    AreaElemStyle areaElemStyle = this.areas.get("n" + object + "=" + string);
                    if (areaElemStyle == null || areaElemStyle.closed && bl) {
                        areaElemStyle = this.areas.get("b" + object + "=" + OsmUtils.getNamedOsmBoolean(string));
                    }
                    if (areaElemStyle == null || areaElemStyle.closed && bl) {
                        areaElemStyle = this.areas.get("x" + object);
                    }
                    if (areaElemStyle == null || areaElemStyle.closed && bl) continue;
                    return true;
                }
                for (AreaElemStyle areaElemStyle : this.areasList) {
                    if (areaElemStyle.closed && bl || !areaElemStyle.check(osmPrimitive)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasAreas() {
            return this.areas.size() > 0;
        }
    }
}

