/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.StyleSources;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private StyleSources sources;
    private JCheckBox sortMenu;
    private JCheckBox enableDefault;

    public void addGui(PreferenceDialog preferenceDialog) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("taggingpreset.enable-defaults", true));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)this.enableDefault, GBC.eol().insets(5, 0, 5, 0));
        this.sources = new StyleSources("taggingpreset.sources", "taggingpreset.icon.sources", "http://josm.openstreetmap.de/presets", false, I18n.tr("Tagging Presets"));
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        preferenceDialog.mapcontent.addTab(I18n.tr("Tagging Presets"), jScrollPane);
    }

    public boolean ok() {
        boolean bl = Main.pref.put("taggingpreset.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        if (Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null)) {
            bl = true;
        }
        if (this.sources.finish()) {
            bl = true;
        }
        return bl;
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences();
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            HashMap<TaggingPresetMenu, JMenuItem> hashMap = new HashMap<TaggingPresetMenu, JMenuItem>();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : Main.main.menu.presetsMenu;
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    jMenuItem.setText(taggingPreset.getLocaleName());
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(taggingPreset.getLocaleName());
                jMenu.add(jMenuItem);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

