/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.tools.I18n;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private int currentProgressValue = 0;
    private ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer progressRenderer) {
        super(new CancelHandler());
        if (progressRenderer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "delegate"));
        }
        this.delegate = progressRenderer;
    }

    private void doInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void doBeginTask() {
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText("");
                SwingRenderingProgressMonitor.this.delegate.setMaximum(100);
            }
        });
    }

    public void doFinishTask() {
    }

    protected void updateProgress(double d) {
        int n = (int)(d * 100.0);
        if (n != this.currentProgressValue) {
            this.currentProgressValue = n;
            this.doInEDT(new Runnable(){

                public void run() {
                    SwingRenderingProgressMonitor.this.delegate.setValue(SwingRenderingProgressMonitor.this.currentProgressValue);
                }
            });
        }
    }

    protected void doSetCustomText(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText(string);
            }
        });
    }

    protected void doSetTitle(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setTaskTitle(string);
            }
        });
    }

    protected void doSetIntermediate(final boolean bl) {
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setIndeterminate(bl);
            }
        });
    }

    protected void doSetErrorMessage(String string) {
    }
}

