/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagEditorPanel
extends JPanel {
    private TagEditorModel model;
    private TagTable tagTable;
    private AutoCompletionCache acCache;
    private AutoCompletionList acList;

    protected JPanel buildTagTableEditorPanel() {
        JPanel jPanel = new JPanel();
        this.model = new TagEditorModel();
        this.tagTable = new TagTable(this.model);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tagTable), "Center");
        return jPanel;
    }

    protected JPanel buildButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        AddAction addAction = new AddAction();
        jPanel.add(new JButton(addAction));
        this.tagTable.addPropertyChangeListener(addAction);
        DeleteAction deleteAction = new DeleteAction();
        this.tagTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.tagTable.addPropertyChangeListener(deleteAction);
        jPanel.add(new JButton(deleteAction));
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.buildTagTableEditorPanel();
        JPanel jPanel2 = this.buildButtonsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public TagEditorPanel() {
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer osmDataLayer) {
        this.acCache = AutoCompletionCache.getCacheForLayer(osmDataLayer);
        this.acCache.initFromDataSet();
        this.acList = new AutoCompletionList();
        TagCellEditor tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
        tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
    }

    public void setEnabled(boolean bl) {
        this.tagTable.setEnabled(bl);
        super.setEnabled(bl);
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener,
    PropertyChangeListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        protected void deleteTagNames() {
            int[] nArray = TagEditorPanel.this.tagTable.getSelectedRows();
            TagEditorPanel.this.model.deleteTagNames(nArray);
        }

        protected void deleteTagValues() {
            int[] nArray = TagEditorPanel.this.tagTable.getSelectedRows();
            TagEditorPanel.this.model.deleteTagValues(nArray);
        }

        protected void deleteTags() {
            TagEditorPanel.this.model.deleteTags(TagEditorPanel.this.tagTable.getSelectedRows());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (TagEditorPanel.this.tagTable.getSelectedColumnCount() == 1) {
                if (TagEditorPanel.this.tagTable.getSelectedColumn() == 0) {
                    this.deleteTagNames();
                } else {
                    if (TagEditorPanel.this.tagTable.getSelectedColumn() != 1) throw new IllegalStateException("unexpected selected column: getSelectedColumn() is " + TagEditorPanel.this.tagTable.getSelectedColumn());
                    this.deleteTagValues();
                }
            } else if (TagEditorPanel.this.tagTable.getSelectedColumnCount() == 2) {
                this.deleteTags();
            }
            if (TagEditorPanel.this.model.getRowCount() != 0) return;
            TagEditorPanel.this.model.ensureOneTag();
        }

        public void updateEnabledState() {
            this.setEnabled(TagEditorPanel.this.tagTable.isEnabled() && (TagEditorPanel.this.tagTable.getSelectedRowCount() > 0 || TagEditorPanel.this.tagTable.getSelectedColumnCount() > 0));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TagEditorPanel.this.model.appendNewTag();
        }

        protected void updateEnabledState() {
            this.setEnabled(TagEditorPanel.this.tagTable.isEnabled());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }
}

