/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;

public class TagTable
extends JTable {
    private static Logger logger = Logger.getLogger(TagTable.class.getName());
    private TagCellEditor editor = null;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    protected void init() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.editor = new TagCellEditor();
        this.editor.setTagEditorModel((TagEditorModel)this.getModel());
        this.getColumnModel().getColumn(0).setCellEditor(this.editor);
        this.getColumnModel().getColumn(1).setCellEditor(this.editor);
    }

    public TagTable(TableModel tableModel) {
        super(tableModel, new TagTableColumnModel());
        this.init();
    }

    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 127) {
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionCache(AutoCompletionCache autoCompletionCache) {
        if (autoCompletionCache == null) {
            logger.warning("argument acCache should not be null. Aborting.");
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionCache(autoCompletionCache);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener keyListener) {
        this.addKeyListener(keyListener);
        if (this.editor == null) {
            logger.warning("editor is null. cannot register OK accelator listener.");
        }
        this.editor.getEditor().addKeyListener(keyListener);
    }

    public void requestFocusInCell(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        SwingUtilities.convertPointToScreen(point, this);
        Point point2 = MouseInfo.getPointerInfo().getLocation();
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.x, point.y);
            robot.mousePress(16);
            robot.mouseRelease(16);
            robot.mouseMove(point2.x, point2.y);
        }
        catch (AWTException aWTException) {
            logger.log(Level.SEVERE, "failed to simulate mouse click event at (" + rectangle.x + "," + rectangle.y + "). Exception: " + aWTException.toString());
            return;
        }
    }

    class AddAction
    extends RunnableAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
        }

        public void run() {
            TagTable.this.getCellEditor().stopCellEditing();
            ((TagEditorModel)TagTable.this.getModel()).appendNewTag();
            int n = TagTable.this.getModel().getRowCount() - 1;
            TagTable.this.requestFocusInCell(n, 0);
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        protected void deleteTagNames() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTagNames(nArray);
        }

        protected void deleteTagValues() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTagValues(nArray);
        }

        protected void deleteTags() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            tagEditorModel.deleteTags(nArray);
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            TagTable.this.getCellEditor().stopCellEditing();
            if (TagTable.this.getSelectedColumnCount() == 1) {
                if (TagTable.this.getSelectedColumn() == 0) {
                    this.deleteTagNames();
                } else {
                    if (TagTable.this.getSelectedColumn() != 1) throw new IllegalStateException("unexpected selected clolumn: getSelectedColumn() is " + TagTable.this.getSelectedColumn());
                    this.deleteTagValues();
                }
            } else if (TagTable.this.getSelectedColumnCount() == 2) {
                this.deleteTags();
            }
            TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
            if (tagEditorModel.getRowCount() != 0) return;
            tagEditorModel.ensureOneTag();
            TagTable.this.requestFocusInCell(0, 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(false);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n > 0 || n2 > 0) {
                if (n == 1) {
                    --n;
                } else {
                    n = 1;
                    --n2;
                }
            }
            TagTable.this.changeSelection(n2, n, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 0) {
                ++n;
            } else if (n == 1 && n2 < TagTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            } else if (n == 1 && n2 == TagTable.this.getRowCount() - 1) {
                TagEditorModel tagEditorModel = (TagEditorModel)TagTable.this.getModel();
                tagEditorModel.appendNewTag();
                n = 0;
                ++n2;
            }
            TagTable.this.changeSelection(n2, n, false, false);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel() {
            TableColumn tableColumn = null;
            TagCellRenderer tagCellRenderer = new TagCellRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Key"));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("Value"));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(tagCellRenderer);
            this.addColumn(tableColumn);
        }
    }
}

