/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteComboBox
extends JComboBox {
    public AutoCompleteComboBox() {
        final JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setDocument(new AutoCompleteComboBoxDocument(this));
        jTextComponent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                jTextComponent.selectAll();
            }
        });
    }

    public void setPossibleItems(Collection<String> collection) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object object = this.getEditor().getItem();
        defaultComboBoxModel.removeAllElements();
        for (String string : collection) {
            defaultComboBoxModel.addElement(string);
        }
        this.getEditor().setItem(object);
    }

    private class AutoCompleteComboBoxDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private boolean selecting = false;

        public AutoCompleteComboBoxDocument(JComboBox jComboBox) {
            this.comboBox = jComboBox;
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(n, n2);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            Object object;
            int n2;
            if (this.selecting || n == 0 && string.equals(this.getText(0, this.getLength()))) {
                return;
            }
            boolean bl = n == 0 && this.getLength() == 0 && string.length() > 1;
            super.insertString(n, string, attributeSet);
            if (this.selecting) {
                return;
            }
            int n3 = this.getLength();
            int n4 = n2 = n + string.length();
            String string2 = this.getText(0, n3);
            Object object2 = this.lookupItem(string2);
            this.setSelectedItem(object2);
            if (bl) {
                n2 = 0;
            }
            if (object2 != null && !((String)(object = object2.toString())).equals(string2)) {
                this.selecting = true;
                super.remove(0, n3);
                super.insertString(0, (String)object, attributeSet);
                this.selecting = false;
                n2 = n3;
                n4 = this.getLength();
            }
            object = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            ((JTextComponent)object).setSelectionStart(n2);
            ((JTextComponent)object).setSelectionEnd(n4);
        }

        private void setSelectedItem(Object object) {
            this.selecting = true;
            this.comboBox.setSelectedItem(object);
            this.selecting = false;
        }

        private Object lookupItem(String string) {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            int n = comboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                Object e = comboBoxModel.getElementAt(i);
                if (!e.toString().startsWith(string)) continue;
                return e;
            }
            return null;
        }
    }
}

